package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEventSchemasRegistryDetails(
    description: Optional[NonEmptyString] = Optional.Absent,
    registryArn: Optional[NonEmptyString] = Optional.Absent,
    registryName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEventSchemasRegistryDetails = {
    import AwsEventSchemasRegistryDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEventSchemasRegistryDetails
      .builder()
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        registryArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.registryArn)
      .optionallyWith(
        registryName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.registryName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEventSchemasRegistryDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEventSchemasRegistryDetails
      .wrap(buildAwsValue())
}
object AwsEventSchemasRegistryDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEventSchemasRegistryDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEventSchemasRegistryDetails =
      zio.aws.securityhub.model.AwsEventSchemasRegistryDetails(
        description.map(value => value),
        registryArn.map(value => value),
        registryName.map(value => value)
      )
    def description: Optional[NonEmptyString]
    def registryArn: Optional[NonEmptyString]
    def registryName: Optional[NonEmptyString]
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getRegistryArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("registryArn", registryArn)
    def getRegistryName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("registryName", registryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventSchemasRegistryDetails
  ) extends zio.aws.securityhub.model.AwsEventSchemasRegistryDetails.ReadOnly {
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val registryArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.registryArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val registryName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.registryName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEventSchemasRegistryDetails
  ): zio.aws.securityhub.model.AwsEventSchemasRegistryDetails.ReadOnly =
    new Wrapper(impl)
}
