package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElbLoadBalancerConnectionSettings(
    idleTimeout: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionSettings = {
    import AwsElbLoadBalancerConnectionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionSettings
      .builder()
      .optionallyWith(idleTimeout.map(value => value: java.lang.Integer))(
        _.idleTimeout
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings.ReadOnly =
    zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings
      .wrap(buildAwsValue())
}
object AwsElbLoadBalancerConnectionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings =
      zio.aws.securityhub.model
        .AwsElbLoadBalancerConnectionSettings(idleTimeout.map(value => value))
    def idleTimeout: Optional[Integer]
    def getIdleTimeout: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("idleTimeout", idleTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionSettings
  ) extends zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings.ReadOnly {
    override val idleTimeout: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.idleTimeout())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElbLoadBalancerConnectionSettings
  ): zio.aws.securityhub.model.AwsElbLoadBalancerConnectionSettings.ReadOnly =
    new Wrapper(impl)
}
