package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEksClusterLoggingClusterLoggingDetails(
    enabled: Optional[Boolean] = Optional.Absent,
    types: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails = {
    import AwsEksClusterLoggingClusterLoggingDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.types)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails
      .wrap(buildAwsValue())
}
object AwsEksClusterLoggingClusterLoggingDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails =
      zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails(
        enabled.map(value => value),
        types.map(value => value)
      )
    def enabled: Optional[Boolean]
    def types: Optional[List[NonEmptyString]]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("types", types)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails
  ) extends zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val types: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.types())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails
  ): zio.aws.securityhub.model.AwsEksClusterLoggingClusterLoggingDetails.ReadOnly =
    new Wrapper(impl)
}
