package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails(
    containerPort: Optional[Integer] = Optional.Absent,
    hostPort: Optional[Integer] = Optional.Absent,
    protocol: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
      .builder()
      .optionallyWith(containerPort.map(value => value: java.lang.Integer))(
        _.containerPort
      )
      .optionallyWith(hostPort.map(value => value: java.lang.Integer))(
        _.hostPort
      )
      .optionallyWith(
        protocol.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.protocol)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails(
          containerPort.map(value => value),
          hostPort.map(value => value),
          protocol.map(value => value)
        )
    def containerPort: Optional[Integer]
    def hostPort: Optional[Integer]
    def protocol: Optional[NonEmptyString]
    def getContainerPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("containerPort", containerPort)
    def getHostPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("hostPort", hostPort)
    def getProtocol: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.ReadOnly {
    override val containerPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.containerPort())
      .map(value => value: Integer)
    override val hostPort: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.hostPort())
      .map(value => value: Integer)
    override val protocol: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.protocol())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails.ReadOnly =
    new Wrapper(impl)
}
