package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcrRepositoryImageScanningConfigurationDetails(
    scanOnPush: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails = {
    import AwsEcrRepositoryImageScanningConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails
      .builder()
      .optionallyWith(scanOnPush.map(value => value: java.lang.Boolean))(
        _.scanOnPush
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcrRepositoryImageScanningConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails =
      zio.aws.securityhub.model
        .AwsEcrRepositoryImageScanningConfigurationDetails(
          scanOnPush.map(value => value)
        )
    def scanOnPush: Optional[Boolean]
    def getScanOnPush: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("scanOnPush", scanOnPush)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails.ReadOnly {
    override val scanOnPush: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.scanOnPush())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcrRepositoryImageScanningConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
