package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails(
    marketType: Optional[NonEmptyString] = Optional.Absent,
    spotOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails = {
    import AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails
      .builder()
      .optionallyWith(
        marketType.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.marketType)
      .optionallyWith(spotOptions.map(value => value.buildAwsValue()))(
        _.spotOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails(
          marketType.map(value => value),
          spotOptions.map(value => value.asEditable)
        )
    def marketType: Optional[NonEmptyString]
    def spotOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.ReadOnly
    ]
    def getMarketType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("marketType", marketType)
    def getSpotOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("spotOptions", spotOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.ReadOnly {
    override val marketType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.marketType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val spotOptions: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.spotOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsSpotOptionsDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataInstanceMarketOptionsDetails.ReadOnly =
    new Wrapper(impl)
}
