package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails(
    capacityReservationPreference: Optional[NonEmptyString] = Optional.Absent,
    capacityReservationTarget: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails = {
    import AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails
      .builder()
      .optionallyWith(
        capacityReservationPreference.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.capacityReservationPreference)
      .optionallyWith(
        capacityReservationTarget.map(value => value.buildAwsValue())
      )(_.capacityReservationTarget)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails(
          capacityReservationPreference.map(value => value),
          capacityReservationTarget.map(value => value.asEditable)
        )
    def capacityReservationPreference: Optional[NonEmptyString]
    def capacityReservationTarget: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.ReadOnly
    ]
    def getCapacityReservationPreference: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "capacityReservationPreference",
        capacityReservationPreference
      )
    def getCapacityReservationTarget: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "capacityReservationTarget",
      capacityReservationTarget
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.ReadOnly {
    override val capacityReservationPreference: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacityReservationPreference())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val capacityReservationTarget: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.capacityReservationTarget())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationCapacityReservationTargetDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataCapacityReservationSpecificationDetails.ReadOnly =
    new Wrapper(impl)
}
