package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails(
    deviceName: Optional[NonEmptyString] = Optional.Absent,
    ebs: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails
    ] = Optional.Absent,
    noDevice: Optional[NonEmptyString] = Optional.Absent,
    virtualName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails = {
    import AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails
      .builder()
      .optionallyWith(
        deviceName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(ebs.map(value => value.buildAwsValue()))(_.ebs)
      .optionallyWith(
        noDevice.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.noDevice)
      .optionallyWith(
        virtualName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.virtualName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails(
          deviceName.map(value => value),
          ebs.map(value => value.asEditable),
          noDevice.map(value => value),
          virtualName.map(value => value)
        )
    def deviceName: Optional[NonEmptyString]
    def ebs: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails.ReadOnly
    ]
    def noDevice: Optional[NonEmptyString]
    def virtualName: Optional[NonEmptyString]
    def getDeviceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getEbs: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails.ReadOnly
    ] = AwsError.unwrapOptionField("ebs", ebs)
    def getNoDevice: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("noDevice", noDevice)
    def getVirtualName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("virtualName", virtualName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.ReadOnly {
    override val deviceName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ebs: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ebs())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetEbsDetails
          .wrap(value)
      )
    override val noDevice: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.noDevice())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val virtualName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.virtualName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataBlockDeviceMappingSetDetails.ReadOnly =
    new Wrapper(impl)
}
