package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2InstanceDetails(
    `type`: Optional[NonEmptyString] = Optional.Absent,
    imageId: Optional[NonEmptyString] = Optional.Absent,
    ipV4Addresses: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    ipV6Addresses: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    keyName: Optional[NonEmptyString] = Optional.Absent,
    iamInstanceProfileArn: Optional[NonEmptyString] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent,
    subnetId: Optional[NonEmptyString] = Optional.Absent,
    launchedAt: Optional[NonEmptyString] = Optional.Absent,
    networkInterfaces: Optional[
      Iterable[zio.aws.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails]
    ] = Optional.Absent,
    virtualizationType: Optional[NonEmptyString] = Optional.Absent,
    metadataOptions: Optional[
      zio.aws.securityhub.model.AwsEc2InstanceMetadataOptions
    ] = Optional.Absent,
    monitoring: Optional[
      zio.aws.securityhub.model.AwsEc2InstanceMonitoringDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceDetails = {
    import AwsEc2InstanceDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceDetails
      .builder()
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        imageId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.imageId)
      .optionallyWith(
        ipV4Addresses.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipV4Addresses)
      .optionallyWith(
        ipV6Addresses.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ipV6Addresses)
      .optionallyWith(
        keyName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.keyName)
      .optionallyWith(
        iamInstanceProfileArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.iamInstanceProfileArn)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .optionallyWith(
        launchedAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.launchedAt)
      .optionallyWith(
        networkInterfaces.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkInterfaces)
      .optionallyWith(
        virtualizationType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.virtualizationType)
      .optionallyWith(metadataOptions.map(value => value.buildAwsValue()))(
        _.metadataOptions
      )
      .optionallyWith(monitoring.map(value => value.buildAwsValue()))(
        _.monitoring
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEc2InstanceDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2InstanceDetails.wrap(buildAwsValue())
}
object AwsEc2InstanceDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2InstanceDetails =
      zio.aws.securityhub.model.AwsEc2InstanceDetails(
        `type`.map(value => value),
        imageId.map(value => value),
        ipV4Addresses.map(value => value),
        ipV6Addresses.map(value => value),
        keyName.map(value => value),
        iamInstanceProfileArn.map(value => value),
        vpcId.map(value => value),
        subnetId.map(value => value),
        launchedAt.map(value => value),
        networkInterfaces.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        virtualizationType.map(value => value),
        metadataOptions.map(value => value.asEditable),
        monitoring.map(value => value.asEditable)
      )
    def `type`: Optional[NonEmptyString]
    def imageId: Optional[NonEmptyString]
    def ipV4Addresses: Optional[List[NonEmptyString]]
    def ipV6Addresses: Optional[List[NonEmptyString]]
    def keyName: Optional[NonEmptyString]
    def iamInstanceProfileArn: Optional[NonEmptyString]
    def vpcId: Optional[NonEmptyString]
    def subnetId: Optional[NonEmptyString]
    def launchedAt: Optional[NonEmptyString]
    def networkInterfaces: Optional[List[
      zio.aws.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails.ReadOnly
    ]]
    def virtualizationType: Optional[NonEmptyString]
    def metadataOptions: Optional[
      zio.aws.securityhub.model.AwsEc2InstanceMetadataOptions.ReadOnly
    ]
    def monitoring: Optional[
      zio.aws.securityhub.model.AwsEc2InstanceMonitoringDetails.ReadOnly
    ]
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
    def getImageId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("imageId", imageId)
    def getIpV4Addresses: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("ipV4Addresses", ipV4Addresses)
    def getIpV6Addresses: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("ipV6Addresses", ipV6Addresses)
    def getKeyName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyName", keyName)
    def getIamInstanceProfileArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("iamInstanceProfileArn", iamInstanceProfileArn)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
    def getLaunchedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("launchedAt", launchedAt)
    def getNetworkInterfaces: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("networkInterfaces", networkInterfaces)
    def getVirtualizationType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("virtualizationType", virtualizationType)
    def getMetadataOptions: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2InstanceMetadataOptions.ReadOnly
    ] = AwsError.unwrapOptionField("metadataOptions", metadataOptions)
    def getMonitoring: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2InstanceMonitoringDetails.ReadOnly
    ] = AwsError.unwrapOptionField("monitoring", monitoring)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceDetails
  ) extends zio.aws.securityhub.model.AwsEc2InstanceDetails.ReadOnly {
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val imageId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.imageId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ipV4Addresses: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipV4Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val ipV6Addresses: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipV6Addresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.primitives.NonEmptyString(item)
          }.toList
        )
    override val keyName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.keyName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iamInstanceProfileArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iamInstanceProfileArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val subnetId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val launchedAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.launchedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val networkInterfaces: Optional[List[
      zio.aws.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.networkInterfaces())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2InstanceNetworkInterfacesDetails
            .wrap(item)
        }.toList
      )
    override val virtualizationType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualizationType())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val metadataOptions: Optional[
      zio.aws.securityhub.model.AwsEc2InstanceMetadataOptions.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.metadataOptions())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2InstanceMetadataOptions.wrap(value)
      )
    override val monitoring: Optional[
      zio.aws.securityhub.model.AwsEc2InstanceMonitoringDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.monitoring())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2InstanceMonitoringDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2InstanceDetails
  ): zio.aws.securityhub.model.AwsEc2InstanceDetails.ReadOnly = new Wrapper(
    impl
  )
}
