package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableLocalSecondaryIndex(
    indexArn: Optional[NonEmptyString] = Optional.Absent,
    indexName: Optional[NonEmptyString] = Optional.Absent,
    keySchema: Optional[
      Iterable[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema]
    ] = Optional.Absent,
    projection: Optional[zio.aws.securityhub.model.AwsDynamoDbTableProjection] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex = {
    import AwsDynamoDbTableLocalSecondaryIndex.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex
      .builder()
      .optionallyWith(
        indexArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.indexArn)
      .optionallyWith(
        indexName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.indexName)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(projection.map(value => value.buildAwsValue()))(
        _.projection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex
      .wrap(buildAwsValue())
}
object AwsDynamoDbTableLocalSecondaryIndex {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex =
      zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex(
        indexArn.map(value => value),
        indexName.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        projection.map(value => value.asEditable)
      )
    def indexArn: Optional[NonEmptyString]
    def indexName: Optional[NonEmptyString]
    def keySchema: Optional[
      List[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly]
    ]
    def projection: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableProjection.ReadOnly
    ]
    def getIndexArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("indexArn", indexArn)
    def getIndexName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getProjection: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsDynamoDbTableProjection.ReadOnly
    ] = AwsError.unwrapOptionField("projection", projection)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex.ReadOnly {
    override val indexArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.indexArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val indexName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val keySchema: Optional[
      List[zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.keySchema())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsDynamoDbTableKeySchema.wrap(item)
        }.toList
      )
    override val projection: Optional[
      zio.aws.securityhub.model.AwsDynamoDbTableProjection.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.projection())
      .map(value =>
        zio.aws.securityhub.model.AwsDynamoDbTableProjection.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex
  ): zio.aws.securityhub.model.AwsDynamoDbTableLocalSecondaryIndex.ReadOnly =
    new Wrapper(impl)
}
