package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsDynamoDbTableAttributeDefinition(
    attributeName: Optional[NonEmptyString] = Optional.Absent,
    attributeType: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableAttributeDefinition = {
    import AwsDynamoDbTableAttributeDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableAttributeDefinition
      .builder()
      .optionallyWith(
        attributeName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .optionallyWith(
        attributeType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.attributeType)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition.ReadOnly =
    zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition
      .wrap(buildAwsValue())
}
object AwsDynamoDbTableAttributeDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableAttributeDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition =
      zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition(
        attributeName.map(value => value),
        attributeType.map(value => value)
      )
    def attributeName: Optional[NonEmptyString]
    def attributeType: Optional[NonEmptyString]
    def getAttributeName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("attributeType", attributeType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableAttributeDefinition
  ) extends zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition.ReadOnly {
    override val attributeName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val attributeType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.attributeType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsDynamoDbTableAttributeDefinition
  ): zio.aws.securityhub.model.AwsDynamoDbTableAttributeDefinition.ReadOnly =
    new Wrapper(impl)
}
