package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCodeBuildProjectEnvironmentRegistryCredential(
    credential: Optional[NonEmptyString] = Optional.Absent,
    credentialProvider: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential = {
    import AwsCodeBuildProjectEnvironmentRegistryCredential.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential
      .builder()
      .optionallyWith(
        credential.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.credential)
      .optionallyWith(
        credentialProvider.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.credentialProvider)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential.ReadOnly =
    zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential
      .wrap(buildAwsValue())
}
object AwsCodeBuildProjectEnvironmentRegistryCredential {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential =
      zio.aws.securityhub.model
        .AwsCodeBuildProjectEnvironmentRegistryCredential(
          credential.map(value => value),
          credentialProvider.map(value => value)
        )
    def credential: Optional[NonEmptyString]
    def credentialProvider: Optional[NonEmptyString]
    def getCredential: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("credential", credential)
    def getCredentialProvider: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("credentialProvider", credentialProvider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential
  ) extends zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential.ReadOnly {
    override val credential: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.credential())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val credentialProvider: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.credentialProvider())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential
  ): zio.aws.securityhub.model.AwsCodeBuildProjectEnvironmentRegistryCredential.ReadOnly =
    new Wrapper(impl)
}
