package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsCloudFrontDistributionOriginSslProtocols(
    items: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    quantity: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols = {
    import AwsCloudFrontDistributionOriginSslProtocols.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols
      .builder()
      .optionallyWith(
        items.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.items)
      .optionallyWith(quantity.map(value => value: java.lang.Integer))(
        _.quantity
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols.ReadOnly =
    zio.aws.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols
      .wrap(buildAwsValue())
}
object AwsCloudFrontDistributionOriginSslProtocols {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols =
      zio.aws.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols(
        items.map(value => value),
        quantity.map(value => value)
      )
    def items: Optional[List[NonEmptyString]]
    def quantity: Optional[Integer]
    def getItems: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("items", items)
    def getQuantity: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("quantity", quantity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols
  ) extends zio.aws.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols.ReadOnly {
    override val items: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.items())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val quantity: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.quantity())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols
  ): zio.aws.securityhub.model.AwsCloudFrontDistributionOriginSslProtocols.ReadOnly =
    new Wrapper(impl)
}
