package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsBackupRecoveryPointDetails(
    backupSizeInBytes: Optional[Long] = Optional.Absent,
    backupVaultArn: Optional[NonEmptyString] = Optional.Absent,
    backupVaultName: Optional[NonEmptyString] = Optional.Absent,
    calculatedLifecycle: Optional[
      zio.aws.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails
    ] = Optional.Absent,
    completionDate: Optional[NonEmptyString] = Optional.Absent,
    createdBy: Optional[
      zio.aws.securityhub.model.AwsBackupRecoveryPointCreatedByDetails
    ] = Optional.Absent,
    creationDate: Optional[NonEmptyString] = Optional.Absent,
    encryptionKeyArn: Optional[NonEmptyString] = Optional.Absent,
    iamRoleArn: Optional[NonEmptyString] = Optional.Absent,
    isEncrypted: Optional[Boolean] = Optional.Absent,
    lastRestoreTime: Optional[NonEmptyString] = Optional.Absent,
    lifecycle: Optional[
      zio.aws.securityhub.model.AwsBackupRecoveryPointLifecycleDetails
    ] = Optional.Absent,
    recoveryPointArn: Optional[NonEmptyString] = Optional.Absent,
    resourceArn: Optional[NonEmptyString] = Optional.Absent,
    resourceType: Optional[NonEmptyString] = Optional.Absent,
    sourceBackupVaultArn: Optional[NonEmptyString] = Optional.Absent,
    status: Optional[NonEmptyString] = Optional.Absent,
    statusMessage: Optional[NonEmptyString] = Optional.Absent,
    storageClass: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointDetails = {
    import AwsBackupRecoveryPointDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointDetails
      .builder()
      .optionallyWith(backupSizeInBytes.map(value => value: java.lang.Long))(
        _.backupSizeInBytes
      )
      .optionallyWith(
        backupVaultArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.backupVaultArn)
      .optionallyWith(
        backupVaultName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.backupVaultName)
      .optionallyWith(calculatedLifecycle.map(value => value.buildAwsValue()))(
        _.calculatedLifecycle
      )
      .optionallyWith(
        completionDate.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.completionDate)
      .optionallyWith(createdBy.map(value => value.buildAwsValue()))(
        _.createdBy
      )
      .optionallyWith(
        creationDate.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.creationDate)
      .optionallyWith(
        encryptionKeyArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.encryptionKeyArn)
      .optionallyWith(
        iamRoleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(isEncrypted.map(value => value: java.lang.Boolean))(
        _.isEncrypted
      )
      .optionallyWith(
        lastRestoreTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastRestoreTime)
      .optionallyWith(lifecycle.map(value => value.buildAwsValue()))(
        _.lifecycle
      )
      .optionallyWith(
        recoveryPointArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.recoveryPointArn)
      .optionallyWith(
        resourceArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        resourceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        sourceBackupVaultArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sourceBackupVaultArn)
      .optionallyWith(
        status.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        storageClass.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.storageClass)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsBackupRecoveryPointDetails.ReadOnly =
    zio.aws.securityhub.model.AwsBackupRecoveryPointDetails
      .wrap(buildAwsValue())
}
object AwsBackupRecoveryPointDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsBackupRecoveryPointDetails =
      zio.aws.securityhub.model.AwsBackupRecoveryPointDetails(
        backupSizeInBytes.map(value => value),
        backupVaultArn.map(value => value),
        backupVaultName.map(value => value),
        calculatedLifecycle.map(value => value.asEditable),
        completionDate.map(value => value),
        createdBy.map(value => value.asEditable),
        creationDate.map(value => value),
        encryptionKeyArn.map(value => value),
        iamRoleArn.map(value => value),
        isEncrypted.map(value => value),
        lastRestoreTime.map(value => value),
        lifecycle.map(value => value.asEditable),
        recoveryPointArn.map(value => value),
        resourceArn.map(value => value),
        resourceType.map(value => value),
        sourceBackupVaultArn.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        storageClass.map(value => value)
      )
    def backupSizeInBytes: Optional[Long]
    def backupVaultArn: Optional[NonEmptyString]
    def backupVaultName: Optional[NonEmptyString]
    def calculatedLifecycle: Optional[
      zio.aws.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails.ReadOnly
    ]
    def completionDate: Optional[NonEmptyString]
    def createdBy: Optional[
      zio.aws.securityhub.model.AwsBackupRecoveryPointCreatedByDetails.ReadOnly
    ]
    def creationDate: Optional[NonEmptyString]
    def encryptionKeyArn: Optional[NonEmptyString]
    def iamRoleArn: Optional[NonEmptyString]
    def isEncrypted: Optional[Boolean]
    def lastRestoreTime: Optional[NonEmptyString]
    def lifecycle: Optional[
      zio.aws.securityhub.model.AwsBackupRecoveryPointLifecycleDetails.ReadOnly
    ]
    def recoveryPointArn: Optional[NonEmptyString]
    def resourceArn: Optional[NonEmptyString]
    def resourceType: Optional[NonEmptyString]
    def sourceBackupVaultArn: Optional[NonEmptyString]
    def status: Optional[NonEmptyString]
    def statusMessage: Optional[NonEmptyString]
    def storageClass: Optional[NonEmptyString]
    def getBackupSizeInBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("backupSizeInBytes", backupSizeInBytes)
    def getBackupVaultArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("backupVaultArn", backupVaultArn)
    def getBackupVaultName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("backupVaultName", backupVaultName)
    def getCalculatedLifecycle: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails.ReadOnly
    ] = AwsError.unwrapOptionField("calculatedLifecycle", calculatedLifecycle)
    def getCompletionDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("completionDate", completionDate)
    def getCreatedBy: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsBackupRecoveryPointCreatedByDetails.ReadOnly
    ] = AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreationDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getEncryptionKeyArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
    def getIamRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getIsEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isEncrypted", isEncrypted)
    def getLastRestoreTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastRestoreTime", lastRestoreTime)
    def getLifecycle: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsBackupRecoveryPointLifecycleDetails.ReadOnly
    ] = AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getRecoveryPointArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("recoveryPointArn", recoveryPointArn)
    def getResourceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getResourceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getSourceBackupVaultArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceBackupVaultArn", sourceBackupVaultArn)
    def getStatus: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStorageClass: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("storageClass", storageClass)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointDetails
  ) extends zio.aws.securityhub.model.AwsBackupRecoveryPointDetails.ReadOnly {
    override val backupSizeInBytes: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.backupSizeInBytes())
      .map(value => value: Long)
    override val backupVaultArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val backupVaultName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backupVaultName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val calculatedLifecycle: Optional[
      zio.aws.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.calculatedLifecycle())
      .map(value =>
        zio.aws.securityhub.model.AwsBackupRecoveryPointCalculatedLifecycleDetails
          .wrap(value)
      )
    override val completionDate: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.completionDate())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val createdBy: Optional[
      zio.aws.securityhub.model.AwsBackupRecoveryPointCreatedByDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value =>
        zio.aws.securityhub.model.AwsBackupRecoveryPointCreatedByDetails
          .wrap(value)
      )
    override val creationDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val encryptionKeyArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKeyArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val iamRoleArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val isEncrypted: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isEncrypted())
      .map(value => value: Boolean)
    override val lastRestoreTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastRestoreTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val lifecycle: Optional[
      zio.aws.securityhub.model.AwsBackupRecoveryPointLifecycleDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lifecycle())
      .map(value =>
        zio.aws.securityhub.model.AwsBackupRecoveryPointLifecycleDetails
          .wrap(value)
      )
    override val recoveryPointArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recoveryPointArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val resourceArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val resourceType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourceBackupVaultArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceBackupVaultArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val status: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val statusMessage: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val storageClass: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.storageClass())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupRecoveryPointDetails
  ): zio.aws.securityhub.model.AwsBackupRecoveryPointDetails.ReadOnly =
    new Wrapper(impl)
}
