package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsBackupBackupPlanLifecycleDetails(
    deleteAfterDays: Optional[Long] = Optional.Absent,
    moveToColdStorageAfterDays: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanLifecycleDetails = {
    import AwsBackupBackupPlanLifecycleDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanLifecycleDetails
      .builder()
      .optionallyWith(deleteAfterDays.map(value => value: java.lang.Long))(
        _.deleteAfterDays
      )
      .optionallyWith(
        moveToColdStorageAfterDays.map(value => value: java.lang.Long)
      )(_.moveToColdStorageAfterDays)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails.ReadOnly =
    zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails
      .wrap(buildAwsValue())
}
object AwsBackupBackupPlanLifecycleDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanLifecycleDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails =
      zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails(
        deleteAfterDays.map(value => value),
        moveToColdStorageAfterDays.map(value => value)
      )
    def deleteAfterDays: Optional[Long]
    def moveToColdStorageAfterDays: Optional[Long]
    def getDeleteAfterDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("deleteAfterDays", deleteAfterDays)
    def getMoveToColdStorageAfterDays: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "moveToColdStorageAfterDays",
        moveToColdStorageAfterDays
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanLifecycleDetails
  ) extends zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails.ReadOnly {
    override val deleteAfterDays: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteAfterDays())
      .map(value => value: Long)
    override val moveToColdStorageAfterDays: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.moveToColdStorageAfterDays())
        .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsBackupBackupPlanLifecycleDetails
  ): zio.aws.securityhub.model.AwsBackupBackupPlanLifecycleDetails.ReadOnly =
    new Wrapper(impl)
}
