package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAutoScalingLaunchConfigurationMetadataOptions(
    httpEndpoint: Optional[NonEmptyString] = Optional.Absent,
    httpPutResponseHopLimit: Optional[Integer] = Optional.Absent,
    httpTokens: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions = {
    import AwsAutoScalingLaunchConfigurationMetadataOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions
      .builder()
      .optionallyWith(
        httpEndpoint.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.httpEndpoint)
      .optionallyWith(
        httpPutResponseHopLimit.map(value => value: java.lang.Integer)
      )(_.httpPutResponseHopLimit)
      .optionallyWith(
        httpTokens.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.httpTokens)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions.ReadOnly =
    zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions
      .wrap(buildAwsValue())
}
object AwsAutoScalingLaunchConfigurationMetadataOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions =
      zio.aws.securityhub.model
        .AwsAutoScalingLaunchConfigurationMetadataOptions(
          httpEndpoint.map(value => value),
          httpPutResponseHopLimit.map(value => value),
          httpTokens.map(value => value)
        )
    def httpEndpoint: Optional[NonEmptyString]
    def httpPutResponseHopLimit: Optional[Integer]
    def httpTokens: Optional[NonEmptyString]
    def getHttpEndpoint: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("httpEndpoint", httpEndpoint)
    def getHttpPutResponseHopLimit: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("httpPutResponseHopLimit", httpPutResponseHopLimit)
    def getHttpTokens: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("httpTokens", httpTokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions
  ) extends zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions.ReadOnly {
    override val httpEndpoint: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.httpEndpoint())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val httpPutResponseHopLimit: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpPutResponseHopLimit())
        .map(value => value: Integer)
    override val httpTokens: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.httpTokens())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions
  ): zio.aws.securityhub.model.AwsAutoScalingLaunchConfigurationMetadataOptions.ReadOnly =
    new Wrapper(impl)
}
