package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails(
    authenticationType: Optional[NonEmptyString] = Optional.Absent,
    lambdaAuthorizerConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails
    ] = Optional.Absent,
    openIdConnectConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails
    ] = Optional.Absent,
    userPoolConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails = {
    import AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails
      .builder()
      .optionallyWith(
        authenticationType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.authenticationType)
      .optionallyWith(
        lambdaAuthorizerConfig.map(value => value.buildAwsValue())
      )(_.lambdaAuthorizerConfig)
      .optionallyWith(openIdConnectConfig.map(value => value.buildAwsValue()))(
        _.openIdConnectConfig
      )
      .optionallyWith(userPoolConfig.map(value => value.buildAwsValue()))(
        _.userPoolConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails
      .wrap(buildAwsValue())
}
object AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails =
      zio.aws.securityhub.model
        .AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails(
          authenticationType.map(value => value),
          lambdaAuthorizerConfig.map(value => value.asEditable),
          openIdConnectConfig.map(value => value.asEditable),
          userPoolConfig.map(value => value.asEditable)
        )
    def authenticationType: Optional[NonEmptyString]
    def lambdaAuthorizerConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.ReadOnly
    ]
    def openIdConnectConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.ReadOnly
    ]
    def userPoolConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails.ReadOnly
    ]
    def getAuthenticationType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getLambdaAuthorizerConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lambdaAuthorizerConfig",
      lambdaAuthorizerConfig
    )
    def getOpenIdConnectConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("openIdConnectConfig", openIdConnectConfig)
    def getUserPoolConfig: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails.ReadOnly
    ] = AwsError.unwrapOptionField("userPoolConfig", userPoolConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails
  ) extends zio.aws.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.ReadOnly {
    override val authenticationType: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val lambdaAuthorizerConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lambdaAuthorizerConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails
          .wrap(value)
      )
    override val openIdConnectConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.openIdConnectConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsAppSyncGraphQlApiOpenIdConnectConfigDetails
          .wrap(value)
      )
    override val userPoolConfig: Optional[
      zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.userPoolConfig())
      .map(value =>
        zio.aws.securityhub.model.AwsAppSyncGraphQlApiUserPoolConfigDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails
  ): zio.aws.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.ReadOnly =
    new Wrapper(impl)
}
