package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsAmazonMqBrokerLogsDetails(
    audit: Optional[Boolean] = Optional.Absent,
    general: Optional[Boolean] = Optional.Absent,
    auditLogGroup: Optional[NonEmptyString] = Optional.Absent,
    generalLogGroup: Optional[NonEmptyString] = Optional.Absent,
    pending: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLogsDetails = {
    import AwsAmazonMqBrokerLogsDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLogsDetails
      .builder()
      .optionallyWith(audit.map(value => value: java.lang.Boolean))(_.audit)
      .optionallyWith(general.map(value => value: java.lang.Boolean))(_.general)
      .optionallyWith(
        auditLogGroup.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.auditLogGroup)
      .optionallyWith(
        generalLogGroup.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.generalLogGroup)
      .optionallyWith(pending.map(value => value.buildAwsValue()))(_.pending)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsAmazonMqBrokerLogsDetails.ReadOnly =
    zio.aws.securityhub.model.AwsAmazonMqBrokerLogsDetails.wrap(buildAwsValue())
}
object AwsAmazonMqBrokerLogsDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLogsDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsAmazonMqBrokerLogsDetails =
      zio.aws.securityhub.model.AwsAmazonMqBrokerLogsDetails(
        audit.map(value => value),
        general.map(value => value),
        auditLogGroup.map(value => value),
        generalLogGroup.map(value => value),
        pending.map(value => value.asEditable)
      )
    def audit: Optional[Boolean]
    def general: Optional[Boolean]
    def auditLogGroup: Optional[NonEmptyString]
    def generalLogGroup: Optional[NonEmptyString]
    def pending: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails.ReadOnly
    ]
    def getAudit: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("audit", audit)
    def getGeneral: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("general", general)
    def getAuditLogGroup: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("auditLogGroup", auditLogGroup)
    def getGeneralLogGroup: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("generalLogGroup", generalLogGroup)
    def getPending: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails.ReadOnly
    ] = AwsError.unwrapOptionField("pending", pending)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLogsDetails
  ) extends zio.aws.securityhub.model.AwsAmazonMqBrokerLogsDetails.ReadOnly {
    override val audit: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.audit())
      .map(value => value: Boolean)
    override val general: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.general())
      .map(value => value: Boolean)
    override val auditLogGroup: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.auditLogGroup())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val generalLogGroup: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.generalLogGroup())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val pending: Optional[
      zio.aws.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pending())
      .map(value =>
        zio.aws.securityhub.model.AwsAmazonMqBrokerLogsPendingDetails
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsAmazonMqBrokerLogsDetails
  ): zio.aws.securityhub.model.AwsAmazonMqBrokerLogsDetails.ReadOnly =
    new Wrapper(impl)
}
