package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AutomationRulesFindingFilters(
    productArn: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    awsAccountId: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    id: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    generatorId: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    `type`: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    firstObservedAt: Optional[Iterable[zio.aws.securityhub.model.DateFilter]] =
      Optional.Absent,
    lastObservedAt: Optional[Iterable[zio.aws.securityhub.model.DateFilter]] =
      Optional.Absent,
    createdAt: Optional[Iterable[zio.aws.securityhub.model.DateFilter]] =
      Optional.Absent,
    updatedAt: Optional[Iterable[zio.aws.securityhub.model.DateFilter]] =
      Optional.Absent,
    confidence: Optional[Iterable[zio.aws.securityhub.model.NumberFilter]] =
      Optional.Absent,
    criticality: Optional[Iterable[zio.aws.securityhub.model.NumberFilter]] =
      Optional.Absent,
    title: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    description: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    sourceUrl: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    productName: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    companyName: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    severityLabel: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    resourceType: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    resourceId: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    resourcePartition: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    resourceRegion: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    resourceTags: Optional[Iterable[zio.aws.securityhub.model.MapFilter]] =
      Optional.Absent,
    resourceDetailsOther: Optional[
      Iterable[zio.aws.securityhub.model.MapFilter]
    ] = Optional.Absent,
    complianceStatus: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    complianceSecurityControlId: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    complianceAssociatedStandardsId: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    verificationState: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    workflowStatus: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    recordState: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    relatedFindingsProductArn: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    relatedFindingsId: Optional[
      Iterable[zio.aws.securityhub.model.StringFilter]
    ] = Optional.Absent,
    noteText: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    noteUpdatedAt: Optional[Iterable[zio.aws.securityhub.model.DateFilter]] =
      Optional.Absent,
    noteUpdatedBy: Optional[Iterable[zio.aws.securityhub.model.StringFilter]] =
      Optional.Absent,
    userDefinedFields: Optional[Iterable[zio.aws.securityhub.model.MapFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFilters = {
    import AutomationRulesFindingFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFilters
      .builder()
      .optionallyWith(
        productArn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productArn)
      .optionallyWith(
        awsAccountId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.awsAccountId)
      .optionallyWith(
        id.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.id)
      .optionallyWith(
        generatorId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.generatorId)
      .optionallyWith(
        `type`.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.`type`)
      .optionallyWith(
        firstObservedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.firstObservedAt)
      .optionallyWith(
        lastObservedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lastObservedAt)
      .optionallyWith(
        createdAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.createdAt)
      .optionallyWith(
        updatedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.updatedAt)
      .optionallyWith(
        confidence.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.confidence)
      .optionallyWith(
        criticality.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.criticality)
      .optionallyWith(
        title.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.title)
      .optionallyWith(
        description.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.description)
      .optionallyWith(
        sourceUrl.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sourceUrl)
      .optionallyWith(
        productName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.productName)
      .optionallyWith(
        companyName.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.companyName)
      .optionallyWith(
        severityLabel.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.severityLabel)
      .optionallyWith(
        resourceType.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceId)
      .optionallyWith(
        resourcePartition.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourcePartition)
      .optionallyWith(
        resourceRegion.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRegion)
      .optionallyWith(
        resourceTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceTags)
      .optionallyWith(
        resourceDetailsOther.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceDetailsOther)
      .optionallyWith(
        complianceStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.complianceStatus)
      .optionallyWith(
        complianceSecurityControlId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.complianceSecurityControlId)
      .optionallyWith(
        complianceAssociatedStandardsId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.complianceAssociatedStandardsId)
      .optionallyWith(
        verificationState.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.verificationState)
      .optionallyWith(
        workflowStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.workflowStatus)
      .optionallyWith(
        recordState.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recordState)
      .optionallyWith(
        relatedFindingsProductArn.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedFindingsProductArn)
      .optionallyWith(
        relatedFindingsId.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedFindingsId)
      .optionallyWith(
        noteText.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noteText)
      .optionallyWith(
        noteUpdatedAt.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noteUpdatedAt)
      .optionallyWith(
        noteUpdatedBy.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.noteUpdatedBy)
      .optionallyWith(
        userDefinedFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userDefinedFields)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AutomationRulesFindingFilters.ReadOnly =
    zio.aws.securityhub.model.AutomationRulesFindingFilters
      .wrap(buildAwsValue())
}
object AutomationRulesFindingFilters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFilters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AutomationRulesFindingFilters =
      zio.aws.securityhub.model.AutomationRulesFindingFilters(
        productArn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        awsAccountId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        id.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        generatorId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        firstObservedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastObservedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        updatedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        confidence.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        criticality.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        title.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        sourceUrl.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        productName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        companyName.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        severityLabel.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceType.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourcePartition.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceRegion.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceDetailsOther.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        complianceStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        complianceSecurityControlId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        complianceAssociatedStandardsId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        verificationState.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        workflowStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        recordState.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relatedFindingsProductArn.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        relatedFindingsId.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noteText.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noteUpdatedAt.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        noteUpdatedBy.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userDefinedFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def productArn
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def awsAccountId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def id: Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def generatorId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def `type`: Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def firstObservedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def lastObservedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def createdAt: Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def updatedAt: Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def confidence
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def criticality
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]]
    def title: Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def description
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def sourceUrl
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def productName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def companyName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def severityLabel
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceType
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourcePartition
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceRegion
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def resourceTags
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]]
    def resourceDetailsOther
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]]
    def complianceStatus
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def complianceSecurityControlId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def complianceAssociatedStandardsId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def verificationState
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def workflowStatus
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def recordState
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def relatedFindingsProductArn
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def relatedFindingsId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def noteText
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def noteUpdatedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]]
    def noteUpdatedBy
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]]
    def userDefinedFields
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]]
    def getProductArn: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("productArn", productArn)
    def getAwsAccountId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("awsAccountId", awsAccountId)
    def getId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("id", id)
    def getGeneratorId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("generatorId", generatorId)
    def getType: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("type", `type`)
    def getFirstObservedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("firstObservedAt", firstObservedAt)
    def getLastObservedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("lastObservedAt", lastObservedAt)
    def getCreatedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getConfidence: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("confidence", confidence)
    def getCriticality: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.NumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("criticality", criticality)
    def getTitle: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("title", title)
    def getDescription: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("description", description)
    def getSourceUrl: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("sourceUrl", sourceUrl)
    def getProductName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("productName", productName)
    def getCompanyName: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("companyName", companyName)
    def getSeverityLabel: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("severityLabel", severityLabel)
    def getResourceType: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourcePartition: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourcePartition", resourcePartition)
    def getResourceRegion: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceRegion", resourceRegion)
    def getResourceTags: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.MapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceTags", resourceTags)
    def getResourceDetailsOther: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.MapFilter.ReadOnly
    ]] =
      AwsError.unwrapOptionField("resourceDetailsOther", resourceDetailsOther)
    def getComplianceStatus: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("complianceStatus", complianceStatus)
    def getComplianceSecurityControlId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "complianceSecurityControlId",
      complianceSecurityControlId
    )
    def getComplianceAssociatedStandardsId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "complianceAssociatedStandardsId",
      complianceAssociatedStandardsId
    )
    def getVerificationState: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("verificationState", verificationState)
    def getWorkflowStatus: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("workflowStatus", workflowStatus)
    def getRecordState: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("recordState", recordState)
    def getRelatedFindingsProductArn: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "relatedFindingsProductArn",
      relatedFindingsProductArn
    )
    def getRelatedFindingsId: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("relatedFindingsId", relatedFindingsId)
    def getNoteText: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("noteText", noteText)
    def getNoteUpdatedAt: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.DateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("noteUpdatedAt", noteUpdatedAt)
    def getNoteUpdatedBy: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.StringFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("noteUpdatedBy", noteUpdatedBy)
    def getUserDefinedFields: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.MapFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("userDefinedFields", userDefinedFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFilters
  ) extends zio.aws.securityhub.model.AutomationRulesFindingFilters.ReadOnly {
    override val productArn
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productArn())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val awsAccountId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsAccountId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val id
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.id())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val generatorId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.generatorId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val `type`
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val firstObservedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firstObservedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val lastObservedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastObservedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val createdAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val updatedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val confidence
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.confidence())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.NumberFilter.wrap(item)
          }.toList
        )
    override val criticality
        : Optional[List[zio.aws.securityhub.model.NumberFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.criticality())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.NumberFilter.wrap(item)
          }.toList
        )
    override val title
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.title())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val description
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val sourceUrl
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceUrl())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val productName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val companyName
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.companyName())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val severityLabel
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severityLabel())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceType
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourcePartition
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourcePartition())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceRegion
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRegion())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val resourceTags
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.MapFilter.wrap(item)
          }.toList
        )
    override val resourceDetailsOther
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceDetailsOther())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.MapFilter.wrap(item)
          }.toList
        )
    override val complianceStatus
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceStatus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val complianceSecurityControlId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceSecurityControlId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val complianceAssociatedStandardsId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceAssociatedStandardsId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val verificationState
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verificationState())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val workflowStatus
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflowStatus())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val recordState
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordState())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val relatedFindingsProductArn
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedFindingsProductArn())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val relatedFindingsId
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedFindingsId())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val noteText
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noteText())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val noteUpdatedAt
        : Optional[List[zio.aws.securityhub.model.DateFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noteUpdatedAt())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.DateFilter.wrap(item)
          }.toList
        )
    override val noteUpdatedBy
        : Optional[List[zio.aws.securityhub.model.StringFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.noteUpdatedBy())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.StringFilter.wrap(item)
          }.toList
        )
    override val userDefinedFields
        : Optional[List[zio.aws.securityhub.model.MapFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userDefinedFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.MapFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFilters
  ): zio.aws.securityhub.model.AutomationRulesFindingFilters.ReadOnly =
    new Wrapper(impl)
}
