package zio.aws.securityhub.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{NonEmptyString, RatioScale}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AutomationRulesFindingFieldsUpdate(
    note: Optional[zio.aws.securityhub.model.NoteUpdate] = Optional.Absent,
    severity: Optional[zio.aws.securityhub.model.SeverityUpdate] =
      Optional.Absent,
    verificationState: Optional[zio.aws.securityhub.model.VerificationState] =
      Optional.Absent,
    confidence: Optional[RatioScale] = Optional.Absent,
    criticality: Optional[RatioScale] = Optional.Absent,
    types: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    userDefinedFields: Optional[Map[NonEmptyString, NonEmptyString]] =
      Optional.Absent,
    workflow: Optional[zio.aws.securityhub.model.WorkflowUpdate] =
      Optional.Absent,
    relatedFindings: Optional[
      Iterable[zio.aws.securityhub.model.RelatedFinding]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFieldsUpdate = {
    import AutomationRulesFindingFieldsUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFieldsUpdate
      .builder()
      .optionallyWith(note.map(value => value.buildAwsValue()))(_.note)
      .optionallyWith(severity.map(value => value.buildAwsValue()))(_.severity)
      .optionallyWith(verificationState.map(value => value.unwrap))(
        _.verificationState
      )
      .optionallyWith(
        confidence.map(value => RatioScale.unwrap(value): Integer)
      )(_.confidence)
      .optionallyWith(
        criticality.map(value => RatioScale.unwrap(value): Integer)
      )(_.criticality)
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.types)
      .optionallyWith(
        userDefinedFields.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.userDefinedFields)
      .optionallyWith(workflow.map(value => value.buildAwsValue()))(_.workflow)
      .optionallyWith(
        relatedFindings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relatedFindings)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AutomationRulesFindingFieldsUpdate.ReadOnly =
    zio.aws.securityhub.model.AutomationRulesFindingFieldsUpdate
      .wrap(buildAwsValue())
}
object AutomationRulesFindingFieldsUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFieldsUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AutomationRulesFindingFieldsUpdate =
      zio.aws.securityhub.model.AutomationRulesFindingFieldsUpdate(
        note.map(value => value.asEditable),
        severity.map(value => value.asEditable),
        verificationState.map(value => value),
        confidence.map(value => value),
        criticality.map(value => value),
        types.map(value => value),
        userDefinedFields.map(value => value),
        workflow.map(value => value.asEditable),
        relatedFindings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def note: Optional[zio.aws.securityhub.model.NoteUpdate.ReadOnly]
    def severity: Optional[zio.aws.securityhub.model.SeverityUpdate.ReadOnly]
    def verificationState: Optional[zio.aws.securityhub.model.VerificationState]
    def confidence: Optional[RatioScale]
    def criticality: Optional[RatioScale]
    def types: Optional[List[NonEmptyString]]
    def userDefinedFields: Optional[Map[NonEmptyString, NonEmptyString]]
    def workflow: Optional[zio.aws.securityhub.model.WorkflowUpdate.ReadOnly]
    def relatedFindings
        : Optional[List[zio.aws.securityhub.model.RelatedFinding.ReadOnly]]
    def getNote
        : ZIO[Any, AwsError, zio.aws.securityhub.model.NoteUpdate.ReadOnly] =
      AwsError.unwrapOptionField("note", note)
    def getSeverity: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.SeverityUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("severity", severity)
    def getVerificationState
        : ZIO[Any, AwsError, zio.aws.securityhub.model.VerificationState] =
      AwsError.unwrapOptionField("verificationState", verificationState)
    def getConfidence: ZIO[Any, AwsError, RatioScale] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getCriticality: ZIO[Any, AwsError, RatioScale] =
      AwsError.unwrapOptionField("criticality", criticality)
    def getTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("types", types)
    def getUserDefinedFields
        : ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("userDefinedFields", userDefinedFields)
    def getWorkflow: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.WorkflowUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("workflow", workflow)
    def getRelatedFindings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.RelatedFinding.ReadOnly
    ]] = AwsError.unwrapOptionField("relatedFindings", relatedFindings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFieldsUpdate
  ) extends zio.aws.securityhub.model.AutomationRulesFindingFieldsUpdate.ReadOnly {
    override val note: Optional[zio.aws.securityhub.model.NoteUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.note())
        .map(value => zio.aws.securityhub.model.NoteUpdate.wrap(value))
    override val severity
        : Optional[zio.aws.securityhub.model.SeverityUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.severity())
        .map(value => zio.aws.securityhub.model.SeverityUpdate.wrap(value))
    override val verificationState
        : Optional[zio.aws.securityhub.model.VerificationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.verificationState())
        .map(value => zio.aws.securityhub.model.VerificationState.wrap(value))
    override val confidence: Optional[RatioScale] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.securityhub.model.primitives.RatioScale(value))
    override val criticality: Optional[RatioScale] = zio.aws.core.internal
      .optionalFromNullable(impl.criticality())
      .map(value => zio.aws.securityhub.model.primitives.RatioScale(value))
    override val types: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.types())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val userDefinedFields
        : Optional[Map[NonEmptyString, NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.userDefinedFields())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.securityhub.model.primitives.NonEmptyString(
              key
            ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
          })
          .toMap
      )
    override val workflow
        : Optional[zio.aws.securityhub.model.WorkflowUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workflow())
        .map(value => zio.aws.securityhub.model.WorkflowUpdate.wrap(value))
    override val relatedFindings
        : Optional[List[zio.aws.securityhub.model.RelatedFinding.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.relatedFindings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.RelatedFinding.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AutomationRulesFindingFieldsUpdate
  ): zio.aws.securityhub.model.AutomationRulesFindingFieldsUpdate.ReadOnly =
    new Wrapper(impl)
}
