package zio.aws.securityhub.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.securityhub.model.primitives.{
  Timestamp,
  RuleOrderValue,
  NonEmptyString
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class AutomationRulesConfig(
    ruleArn: Optional[NonEmptyString] = Optional.Absent,
    ruleStatus: Optional[zio.aws.securityhub.model.RuleStatus] =
      Optional.Absent,
    ruleOrder: Optional[RuleOrderValue] = Optional.Absent,
    ruleName: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    isTerminal: Optional[Boolean] = Optional.Absent,
    criteria: Optional[
      zio.aws.securityhub.model.AutomationRulesFindingFilters
    ] = Optional.Absent,
    actions: Optional[
      Iterable[zio.aws.securityhub.model.AutomationRulesAction]
    ] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    updatedAt: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AutomationRulesConfig = {
    import AutomationRulesConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AutomationRulesConfig
      .builder()
      .optionallyWith(
        ruleArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleArn)
      .optionallyWith(ruleStatus.map(value => value.unwrap))(_.ruleStatus)
      .optionallyWith(
        ruleOrder.map(value => RuleOrderValue.unwrap(value): Integer)
      )(_.ruleOrder)
      .optionallyWith(
        ruleName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleName)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(isTerminal.map(value => value: java.lang.Boolean))(
        _.isTerminal
      )
      .optionallyWith(criteria.map(value => value.buildAwsValue()))(_.criteria)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        createdBy.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdBy)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AutomationRulesConfig.ReadOnly =
    zio.aws.securityhub.model.AutomationRulesConfig.wrap(buildAwsValue())
}
object AutomationRulesConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AutomationRulesConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AutomationRulesConfig =
      zio.aws.securityhub.model.AutomationRulesConfig(
        ruleArn.map(value => value),
        ruleStatus.map(value => value),
        ruleOrder.map(value => value),
        ruleName.map(value => value),
        description.map(value => value),
        isTerminal.map(value => value),
        criteria.map(value => value.asEditable),
        actions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        createdBy.map(value => value)
      )
    def ruleArn: Optional[NonEmptyString]
    def ruleStatus: Optional[zio.aws.securityhub.model.RuleStatus]
    def ruleOrder: Optional[RuleOrderValue]
    def ruleName: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def isTerminal: Optional[Boolean]
    def criteria: Optional[
      zio.aws.securityhub.model.AutomationRulesFindingFilters.ReadOnly
    ]
    def actions: Optional[
      List[zio.aws.securityhub.model.AutomationRulesAction.ReadOnly]
    ]
    def createdAt: Optional[Timestamp]
    def updatedAt: Optional[Timestamp]
    def createdBy: Optional[NonEmptyString]
    def getRuleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleArn", ruleArn)
    def getRuleStatus
        : ZIO[Any, AwsError, zio.aws.securityhub.model.RuleStatus] =
      AwsError.unwrapOptionField("ruleStatus", ruleStatus)
    def getRuleOrder: ZIO[Any, AwsError, RuleOrderValue] =
      AwsError.unwrapOptionField("ruleOrder", ruleOrder)
    def getRuleName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleName", ruleName)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getIsTerminal: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isTerminal", isTerminal)
    def getCriteria: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AutomationRulesFindingFilters.ReadOnly
    ] = AwsError.unwrapOptionField("criteria", criteria)
    def getActions: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AutomationRulesAction.ReadOnly
    ]] = AwsError.unwrapOptionField("actions", actions)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getCreatedBy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdBy", createdBy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AutomationRulesConfig
  ) extends zio.aws.securityhub.model.AutomationRulesConfig.ReadOnly {
    override val ruleArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ruleStatus: Optional[zio.aws.securityhub.model.RuleStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleStatus())
        .map(value => zio.aws.securityhub.model.RuleStatus.wrap(value))
    override val ruleOrder: Optional[RuleOrderValue] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleOrder())
      .map(value => zio.aws.securityhub.model.primitives.RuleOrderValue(value))
    override val ruleName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val isTerminal: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.isTerminal())
      .map(value => value: Boolean)
    override val criteria: Optional[
      zio.aws.securityhub.model.AutomationRulesFindingFilters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.criteria())
      .map(value =>
        zio.aws.securityhub.model.AutomationRulesFindingFilters.wrap(value)
      )
    override val actions: Optional[
      List[zio.aws.securityhub.model.AutomationRulesAction.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.actions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AutomationRulesAction.wrap(item)
        }.toList
      )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.securityhub.model.primitives.Timestamp(value))
    override val updatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.updatedAt())
      .map(value => zio.aws.securityhub.model.primitives.Timestamp(value))
    override val createdBy: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AutomationRulesConfig
  ): zio.aws.securityhub.model.AutomationRulesConfig.ReadOnly = new Wrapper(
    impl
  )
}
