package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UnprocessedStandardsControlAssociation(
    standardsControlAssociationId: zio.aws.securityhub.model.StandardsControlAssociationId,
    errorCode: zio.aws.securityhub.model.UnprocessedErrorCode,
    errorReason: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociation = {
    import UnprocessedStandardsControlAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociation
      .builder()
      .standardsControlAssociationId(
        standardsControlAssociationId.buildAwsValue()
      )
      .errorCode(errorCode.unwrap)
      .optionallyWith(
        errorReason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.errorReason)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.UnprocessedStandardsControlAssociation.ReadOnly =
    zio.aws.securityhub.model.UnprocessedStandardsControlAssociation
      .wrap(buildAwsValue())
}
object UnprocessedStandardsControlAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.UnprocessedStandardsControlAssociation =
      zio.aws.securityhub.model.UnprocessedStandardsControlAssociation(
        standardsControlAssociationId.asEditable,
        errorCode,
        errorReason.map(value => value)
      )
    def standardsControlAssociationId
        : zio.aws.securityhub.model.StandardsControlAssociationId.ReadOnly
    def errorCode: zio.aws.securityhub.model.UnprocessedErrorCode
    def errorReason: Optional[NonEmptyString]
    def getStandardsControlAssociationId: ZIO[
      Any,
      Nothing,
      zio.aws.securityhub.model.StandardsControlAssociationId.ReadOnly
    ] = ZIO.succeed(standardsControlAssociationId)
    def getErrorCode
        : ZIO[Any, Nothing, zio.aws.securityhub.model.UnprocessedErrorCode] =
      ZIO.succeed(errorCode)
    def getErrorReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("errorReason", errorReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociation
  ) extends zio.aws.securityhub.model.UnprocessedStandardsControlAssociation.ReadOnly {
    override val standardsControlAssociationId
        : zio.aws.securityhub.model.StandardsControlAssociationId.ReadOnly =
      zio.aws.securityhub.model.StandardsControlAssociationId
        .wrap(impl.standardsControlAssociationId())
    override val errorCode: zio.aws.securityhub.model.UnprocessedErrorCode =
      zio.aws.securityhub.model.UnprocessedErrorCode.wrap(impl.errorCode())
    override val errorReason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.errorReason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociation
  ): zio.aws.securityhub.model.UnprocessedStandardsControlAssociation.ReadOnly =
    new Wrapper(impl)
}
