package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UnprocessedSecurityControl(
    securityControlId: NonEmptyString,
    errorCode: zio.aws.securityhub.model.UnprocessedErrorCode,
    errorReason: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.UnprocessedSecurityControl = {
    import UnprocessedSecurityControl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.UnprocessedSecurityControl
      .builder()
      .securityControlId(
        NonEmptyString.unwrap(securityControlId): java.lang.String
      )
      .errorCode(errorCode.unwrap)
      .optionallyWith(
        errorReason.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.errorReason)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.UnprocessedSecurityControl.ReadOnly =
    zio.aws.securityhub.model.UnprocessedSecurityControl.wrap(buildAwsValue())
}
object UnprocessedSecurityControl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.UnprocessedSecurityControl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.UnprocessedSecurityControl =
      zio.aws.securityhub.model.UnprocessedSecurityControl(
        securityControlId,
        errorCode,
        errorReason.map(value => value)
      )
    def securityControlId: NonEmptyString
    def errorCode: zio.aws.securityhub.model.UnprocessedErrorCode
    def errorReason: Optional[NonEmptyString]
    def getSecurityControlId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(securityControlId)
    def getErrorCode
        : ZIO[Any, Nothing, zio.aws.securityhub.model.UnprocessedErrorCode] =
      ZIO.succeed(errorCode)
    def getErrorReason: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("errorReason", errorReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.UnprocessedSecurityControl
  ) extends zio.aws.securityhub.model.UnprocessedSecurityControl.ReadOnly {
    override val securityControlId: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.securityControlId())
    override val errorCode: zio.aws.securityhub.model.UnprocessedErrorCode =
      zio.aws.securityhub.model.UnprocessedErrorCode.wrap(impl.errorCode())
    override val errorReason: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.errorReason())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.UnprocessedSecurityControl
  ): zio.aws.securityhub.model.UnprocessedSecurityControl.ReadOnly =
    new Wrapper(impl)
}
