package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ThreatIntelIndicator(
    `type`: Optional[zio.aws.securityhub.model.ThreatIntelIndicatorType] =
      Optional.Absent,
    value: Optional[NonEmptyString] = Optional.Absent,
    category: Optional[zio.aws.securityhub.model.ThreatIntelIndicatorCategory] =
      Optional.Absent,
    lastObservedAt: Optional[NonEmptyString] = Optional.Absent,
    source: Optional[NonEmptyString] = Optional.Absent,
    sourceUrl: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicator = {
    import ThreatIntelIndicator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicator
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(category.map(value => value.unwrap))(_.category)
      .optionallyWith(
        lastObservedAt.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.lastObservedAt)
      .optionallyWith(
        source.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.source)
      .optionallyWith(
        sourceUrl.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.sourceUrl)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.ThreatIntelIndicator.ReadOnly =
    zio.aws.securityhub.model.ThreatIntelIndicator.wrap(buildAwsValue())
}
object ThreatIntelIndicator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.ThreatIntelIndicator =
      zio.aws.securityhub.model.ThreatIntelIndicator(
        `type`.map(value => value),
        value.map(value => value),
        category.map(value => value),
        lastObservedAt.map(value => value),
        source.map(value => value),
        sourceUrl.map(value => value)
      )
    def `type`: Optional[zio.aws.securityhub.model.ThreatIntelIndicatorType]
    def value: Optional[NonEmptyString]
    def category
        : Optional[zio.aws.securityhub.model.ThreatIntelIndicatorCategory]
    def lastObservedAt: Optional[NonEmptyString]
    def source: Optional[NonEmptyString]
    def sourceUrl: Optional[NonEmptyString]
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ThreatIntelIndicatorType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
    def getCategory: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.ThreatIntelIndicatorCategory
    ] = AwsError.unwrapOptionField("category", category)
    def getLastObservedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("lastObservedAt", lastObservedAt)
    def getSource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("source", source)
    def getSourceUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("sourceUrl", sourceUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicator
  ) extends zio.aws.securityhub.model.ThreatIntelIndicator.ReadOnly {
    override val `type`
        : Optional[zio.aws.securityhub.model.ThreatIntelIndicatorType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.securityhub.model.ThreatIntelIndicatorType.wrap(value)
        )
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val category
        : Optional[zio.aws.securityhub.model.ThreatIntelIndicatorCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.category())
        .map(value =>
          zio.aws.securityhub.model.ThreatIntelIndicatorCategory.wrap(value)
        )
    override val lastObservedAt: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastObservedAt())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val source: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sourceUrl: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceUrl())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.ThreatIntelIndicator
  ): zio.aws.securityhub.model.ThreatIntelIndicator.ReadOnly = new Wrapper(impl)
}
