package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SecurityControlDefinition(
    securityControlId: NonEmptyString,
    title: NonEmptyString,
    description: NonEmptyString,
    remediationUrl: NonEmptyString,
    severityRating: zio.aws.securityhub.model.SeverityRating,
    currentRegionAvailability: zio.aws.securityhub.model.RegionAvailabilityStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.SecurityControlDefinition = {
    import SecurityControlDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.SecurityControlDefinition
      .builder()
      .securityControlId(
        NonEmptyString.unwrap(securityControlId): java.lang.String
      )
      .title(NonEmptyString.unwrap(title): java.lang.String)
      .description(NonEmptyString.unwrap(description): java.lang.String)
      .remediationUrl(NonEmptyString.unwrap(remediationUrl): java.lang.String)
      .severityRating(severityRating.unwrap)
      .currentRegionAvailability(currentRegionAvailability.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.SecurityControlDefinition.ReadOnly =
    zio.aws.securityhub.model.SecurityControlDefinition.wrap(buildAwsValue())
}
object SecurityControlDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.SecurityControlDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.SecurityControlDefinition =
      zio.aws.securityhub.model.SecurityControlDefinition(
        securityControlId,
        title,
        description,
        remediationUrl,
        severityRating,
        currentRegionAvailability
      )
    def securityControlId: NonEmptyString
    def title: NonEmptyString
    def description: NonEmptyString
    def remediationUrl: NonEmptyString
    def severityRating: zio.aws.securityhub.model.SeverityRating
    def currentRegionAvailability
        : zio.aws.securityhub.model.RegionAvailabilityStatus
    def getSecurityControlId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(securityControlId)
    def getTitle: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(title)
    def getDescription: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(description)
    def getRemediationUrl: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(remediationUrl)
    def getSeverityRating
        : ZIO[Any, Nothing, zio.aws.securityhub.model.SeverityRating] =
      ZIO.succeed(severityRating)
    def getCurrentRegionAvailability: ZIO[
      Any,
      Nothing,
      zio.aws.securityhub.model.RegionAvailabilityStatus
    ] = ZIO.succeed(currentRegionAvailability)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.SecurityControlDefinition
  ) extends zio.aws.securityhub.model.SecurityControlDefinition.ReadOnly {
    override val securityControlId: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.securityControlId())
    override val title: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.title())
    override val description: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.description())
    override val remediationUrl: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.remediationUrl())
    override val severityRating: zio.aws.securityhub.model.SeverityRating =
      zio.aws.securityhub.model.SeverityRating.wrap(impl.severityRating())
    override val currentRegionAvailability
        : zio.aws.securityhub.model.RegionAvailabilityStatus =
      zio.aws.securityhub.model.RegionAvailabilityStatus
        .wrap(impl.currentRegionAvailability())
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.SecurityControlDefinition
  ): zio.aws.securityhub.model.SecurityControlDefinition.ReadOnly = new Wrapper(
    impl
  )
}
