package zio.aws.securityhub.model
import scala.jdk.CollectionConverters._
sealed trait RecordState {
  def unwrap: software.amazon.awssdk.services.securityhub.model.RecordState
}
object RecordState {
  def wrap(
      value: software.amazon.awssdk.services.securityhub.model.RecordState
  ): zio.aws.securityhub.model.RecordState = value match {
    case software.amazon.awssdk.services.securityhub.model.RecordState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.securityhub.model.RecordState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.securityhub.model.RecordState.ARCHIVED =>
      val r = ARCHIVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.securityhub.model.RecordState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.RecordState =
      software.amazon.awssdk.services.securityhub.model.RecordState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.securityhub.model.RecordState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.RecordState =
      software.amazon.awssdk.services.securityhub.model.RecordState.ACTIVE
  }
  case object ARCHIVED extends zio.aws.securityhub.model.RecordState {
    override def unwrap
        : software.amazon.awssdk.services.securityhub.model.RecordState =
      software.amazon.awssdk.services.securityhub.model.RecordState.ARCHIVED
  }
}
