package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PatchSummary(
    id: NonEmptyString,
    installedCount: Optional[Integer] = Optional.Absent,
    missingCount: Optional[Integer] = Optional.Absent,
    failedCount: Optional[Integer] = Optional.Absent,
    installedOtherCount: Optional[Integer] = Optional.Absent,
    installedRejectedCount: Optional[Integer] = Optional.Absent,
    installedPendingReboot: Optional[Integer] = Optional.Absent,
    operationStartTime: Optional[NonEmptyString] = Optional.Absent,
    operationEndTime: Optional[NonEmptyString] = Optional.Absent,
    rebootOption: Optional[NonEmptyString] = Optional.Absent,
    operation: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.PatchSummary = {
    import PatchSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.PatchSummary
      .builder()
      .id(NonEmptyString.unwrap(id): java.lang.String)
      .optionallyWith(installedCount.map(value => value: java.lang.Integer))(
        _.installedCount
      )
      .optionallyWith(missingCount.map(value => value: java.lang.Integer))(
        _.missingCount
      )
      .optionallyWith(failedCount.map(value => value: java.lang.Integer))(
        _.failedCount
      )
      .optionallyWith(
        installedOtherCount.map(value => value: java.lang.Integer)
      )(_.installedOtherCount)
      .optionallyWith(
        installedRejectedCount.map(value => value: java.lang.Integer)
      )(_.installedRejectedCount)
      .optionallyWith(
        installedPendingReboot.map(value => value: java.lang.Integer)
      )(_.installedPendingReboot)
      .optionallyWith(
        operationStartTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.operationStartTime)
      .optionallyWith(
        operationEndTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.operationEndTime)
      .optionallyWith(
        rebootOption.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.rebootOption)
      .optionallyWith(
        operation.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.operation)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.PatchSummary.ReadOnly =
    zio.aws.securityhub.model.PatchSummary.wrap(buildAwsValue())
}
object PatchSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.PatchSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.PatchSummary =
      zio.aws.securityhub.model.PatchSummary(
        id,
        installedCount.map(value => value),
        missingCount.map(value => value),
        failedCount.map(value => value),
        installedOtherCount.map(value => value),
        installedRejectedCount.map(value => value),
        installedPendingReboot.map(value => value),
        operationStartTime.map(value => value),
        operationEndTime.map(value => value),
        rebootOption.map(value => value),
        operation.map(value => value)
      )
    def id: NonEmptyString
    def installedCount: Optional[Integer]
    def missingCount: Optional[Integer]
    def failedCount: Optional[Integer]
    def installedOtherCount: Optional[Integer]
    def installedRejectedCount: Optional[Integer]
    def installedPendingReboot: Optional[Integer]
    def operationStartTime: Optional[NonEmptyString]
    def operationEndTime: Optional[NonEmptyString]
    def rebootOption: Optional[NonEmptyString]
    def operation: Optional[NonEmptyString]
    def getId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(id)
    def getInstalledCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("installedCount", installedCount)
    def getMissingCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("missingCount", missingCount)
    def getFailedCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("failedCount", failedCount)
    def getInstalledOtherCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("installedOtherCount", installedOtherCount)
    def getInstalledRejectedCount: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("installedRejectedCount", installedRejectedCount)
    def getInstalledPendingReboot: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("installedPendingReboot", installedPendingReboot)
    def getOperationStartTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("operationStartTime", operationStartTime)
    def getOperationEndTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("operationEndTime", operationEndTime)
    def getRebootOption: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("rebootOption", rebootOption)
    def getOperation: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("operation", operation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.PatchSummary
  ) extends zio.aws.securityhub.model.PatchSummary.ReadOnly {
    override val id: NonEmptyString =
      zio.aws.securityhub.model.primitives.NonEmptyString(impl.id())
    override val installedCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.installedCount())
      .map(value => value: Integer)
    override val missingCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.missingCount())
      .map(value => value: Integer)
    override val failedCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.failedCount())
      .map(value => value: Integer)
    override val installedOtherCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.installedOtherCount())
      .map(value => value: Integer)
    override val installedRejectedCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.installedRejectedCount())
        .map(value => value: Integer)
    override val installedPendingReboot: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.installedPendingReboot())
        .map(value => value: Integer)
    override val operationStartTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationStartTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val operationEndTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operationEndTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val rebootOption: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.rebootOption())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val operation: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.operation())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.PatchSummary
  ): zio.aws.securityhub.model.PatchSummary.ReadOnly = new Wrapper(impl)
}
