package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class InsightResultValue(
    groupByAttributeValue: NonEmptyString,
    count: Integer
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.InsightResultValue = {
    import InsightResultValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.InsightResultValue
      .builder()
      .groupByAttributeValue(
        NonEmptyString.unwrap(groupByAttributeValue): java.lang.String
      )
      .count(count: java.lang.Integer)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.InsightResultValue.ReadOnly =
    zio.aws.securityhub.model.InsightResultValue.wrap(buildAwsValue())
}
object InsightResultValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.InsightResultValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.InsightResultValue =
      zio.aws.securityhub.model.InsightResultValue(groupByAttributeValue, count)
    def groupByAttributeValue: NonEmptyString
    def count: Integer
    def getGroupByAttributeValue: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(groupByAttributeValue)
    def getCount: ZIO[Any, Nothing, Integer] = ZIO.succeed(count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.InsightResultValue
  ) extends zio.aws.securityhub.model.InsightResultValue.ReadOnly {
    override val groupByAttributeValue: NonEmptyString =
      zio.aws.securityhub.model.primitives
        .NonEmptyString(impl.groupByAttributeValue())
    override val count: Integer = impl.count(): Integer
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.InsightResultValue
  ): zio.aws.securityhub.model.InsightResultValue.ReadOnly = new Wrapper(impl)
}
