package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DateRange(
    value: Optional[Integer] = Optional.Absent,
    unit: Optional[zio.aws.securityhub.model.DateRangeUnit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DateRange = {
    import DateRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DateRange
      .builder()
      .optionallyWith(value.map(value => value: java.lang.Integer))(_.value)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DateRange.ReadOnly =
    zio.aws.securityhub.model.DateRange.wrap(buildAwsValue())
}
object DateRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DateRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DateRange =
      zio.aws.securityhub.model
        .DateRange(value.map(value => value), unit.map(value => value))
    def value: Optional[Integer]
    def unit: Optional[zio.aws.securityhub.model.DateRangeUnit]
    def getValue: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("value", value)
    def getUnit: ZIO[Any, AwsError, zio.aws.securityhub.model.DateRangeUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DateRange
  ) extends zio.aws.securityhub.model.DateRange.ReadOnly {
    override val value: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: Integer)
    override val unit: Optional[zio.aws.securityhub.model.DateRangeUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.securityhub.model.DateRangeUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DateRange
  ): zio.aws.securityhub.model.DateRange.ReadOnly = new Wrapper(impl)
}
