package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DateFilter(
    start: Optional[NonEmptyString] = Optional.Absent,
    end: Optional[NonEmptyString] = Optional.Absent,
    dateRange: Optional[zio.aws.securityhub.model.DateRange] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.DateFilter = {
    import DateFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.DateFilter
      .builder()
      .optionallyWith(
        start.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.start)
      .optionallyWith(
        end.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.end)
      .optionallyWith(dateRange.map(value => value.buildAwsValue()))(
        _.dateRange
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.DateFilter.ReadOnly =
    zio.aws.securityhub.model.DateFilter.wrap(buildAwsValue())
}
object DateFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.DateFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.DateFilter =
      zio.aws.securityhub.model.DateFilter(
        start.map(value => value),
        end.map(value => value),
        dateRange.map(value => value.asEditable)
      )
    def start: Optional[NonEmptyString]
    def end: Optional[NonEmptyString]
    def dateRange: Optional[zio.aws.securityhub.model.DateRange.ReadOnly]
    def getStart: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("start", start)
    def getEnd: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("end", end)
    def getDateRange
        : ZIO[Any, AwsError, zio.aws.securityhub.model.DateRange.ReadOnly] =
      AwsError.unwrapOptionField("dateRange", dateRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.DateFilter
  ) extends zio.aws.securityhub.model.DateFilter.ReadOnly {
    override val start: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.start())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val end: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.end())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val dateRange
        : Optional[zio.aws.securityhub.model.DateRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dateRange())
        .map(value => zio.aws.securityhub.model.DateRange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.DateFilter
  ): zio.aws.securityhub.model.DateFilter.ReadOnly = new Wrapper(impl)
}
