package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Country(
    countryCode: Optional[NonEmptyString] = Optional.Absent,
    countryName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.Country = {
    import Country.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.Country
      .builder()
      .optionallyWith(
        countryCode.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.countryCode)
      .optionallyWith(
        countryName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.countryName)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.Country.ReadOnly =
    zio.aws.securityhub.model.Country.wrap(buildAwsValue())
}
object Country {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.Country
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.Country =
      zio.aws.securityhub.model.Country(
        countryCode.map(value => value),
        countryName.map(value => value)
      )
    def countryCode: Optional[NonEmptyString]
    def countryName: Optional[NonEmptyString]
    def getCountryCode: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("countryCode", countryCode)
    def getCountryName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("countryName", countryName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.Country
  ) extends zio.aws.securityhub.model.Country.ReadOnly {
    override val countryCode: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.countryCode())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val countryName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.countryName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.Country
  ): zio.aws.securityhub.model.Country.ReadOnly = new Wrapper(impl)
}
