package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchUpdateStandardsControlAssociationsRequest(
    standardsControlAssociationUpdates: Iterable[
      zio.aws.securityhub.model.StandardsControlAssociationUpdate
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsRequest = {
    import BatchUpdateStandardsControlAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsRequest
      .builder()
      .standardsControlAssociationUpdates(
        standardsControlAssociationUpdates.map { item =>
          item.buildAwsValue()
        }.asJavaCollection
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsRequest.ReadOnly =
    zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsRequest
      .wrap(buildAwsValue())
}
object BatchUpdateStandardsControlAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsRequest =
      zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsRequest(
        standardsControlAssociationUpdates.map { item =>
          item.asEditable
        }
      )
    def standardsControlAssociationUpdates: List[
      zio.aws.securityhub.model.StandardsControlAssociationUpdate.ReadOnly
    ]
    def getStandardsControlAssociationUpdates: ZIO[Any, Nothing, List[
      zio.aws.securityhub.model.StandardsControlAssociationUpdate.ReadOnly
    ]] = ZIO.succeed(standardsControlAssociationUpdates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsRequest
  ) extends zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsRequest.ReadOnly {
    override val standardsControlAssociationUpdates: List[
      zio.aws.securityhub.model.StandardsControlAssociationUpdate.ReadOnly
    ] = impl
      .standardsControlAssociationUpdates()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.StandardsControlAssociationUpdate.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsRequest
  ): zio.aws.securityhub.model.BatchUpdateStandardsControlAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
