package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchGetSecurityControlsRequest(
    securityControlIds: Iterable[NonEmptyString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsRequest = {
    import BatchGetSecurityControlsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsRequest
      .builder()
      .securityControlIds(securityControlIds.map { item =>
        NonEmptyString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.BatchGetSecurityControlsRequest.ReadOnly =
    zio.aws.securityhub.model.BatchGetSecurityControlsRequest
      .wrap(buildAwsValue())
}
object BatchGetSecurityControlsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.BatchGetSecurityControlsRequest =
      zio.aws.securityhub.model
        .BatchGetSecurityControlsRequest(securityControlIds)
    def securityControlIds: List[NonEmptyString]
    def getSecurityControlIds: ZIO[Any, Nothing, List[NonEmptyString]] =
      ZIO.succeed(securityControlIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsRequest
  ) extends zio.aws.securityhub.model.BatchGetSecurityControlsRequest.ReadOnly {
    override val securityControlIds: List[NonEmptyString] = impl
      .securityControlIds()
      .asScala
      .map { item =>
        zio.aws.securityhub.model.primitives.NonEmptyString(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsRequest
  ): zio.aws.securityhub.model.BatchGetSecurityControlsRequest.ReadOnly =
    new Wrapper(impl)
}
