package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{NonEmptyString, Integer}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafWebAclRule(
    action: Optional[zio.aws.securityhub.model.WafAction] = Optional.Absent,
    excludedRules: Optional[
      Iterable[zio.aws.securityhub.model.WafExcludedRule]
    ] = Optional.Absent,
    overrideAction: Optional[zio.aws.securityhub.model.WafOverrideAction] =
      Optional.Absent,
    priority: Optional[Integer] = Optional.Absent,
    ruleId: Optional[NonEmptyString] = Optional.Absent,
    `type`: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafWebAclRule = {
    import AwsWafWebAclRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafWebAclRule
      .builder()
      .optionallyWith(action.map(value => value.buildAwsValue()))(_.action)
      .optionallyWith(
        excludedRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludedRules)
      .optionallyWith(overrideAction.map(value => value.buildAwsValue()))(
        _.overrideAction
      )
      .optionallyWith(priority.map(value => value: java.lang.Integer))(
        _.priority
      )
      .optionallyWith(
        ruleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.ruleId)
      .optionallyWith(
        `type`.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsWafWebAclRule.ReadOnly =
    zio.aws.securityhub.model.AwsWafWebAclRule.wrap(buildAwsValue())
}
object AwsWafWebAclRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafWebAclRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafWebAclRule =
      zio.aws.securityhub.model.AwsWafWebAclRule(
        action.map(value => value.asEditable),
        excludedRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        overrideAction.map(value => value.asEditable),
        priority.map(value => value),
        ruleId.map(value => value),
        `type`.map(value => value)
      )
    def action: Optional[zio.aws.securityhub.model.WafAction.ReadOnly]
    def excludedRules
        : Optional[List[zio.aws.securityhub.model.WafExcludedRule.ReadOnly]]
    def overrideAction
        : Optional[zio.aws.securityhub.model.WafOverrideAction.ReadOnly]
    def priority: Optional[Integer]
    def ruleId: Optional[NonEmptyString]
    def `type`: Optional[NonEmptyString]
    def getAction
        : ZIO[Any, AwsError, zio.aws.securityhub.model.WafAction.ReadOnly] =
      AwsError.unwrapOptionField("action", action)
    def getExcludedRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.WafExcludedRule.ReadOnly
    ]] = AwsError.unwrapOptionField("excludedRules", excludedRules)
    def getOverrideAction: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.WafOverrideAction.ReadOnly
    ] = AwsError.unwrapOptionField("overrideAction", overrideAction)
    def getPriority: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("priority", priority)
    def getRuleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("ruleId", ruleId)
    def getType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafWebAclRule
  ) extends zio.aws.securityhub.model.AwsWafWebAclRule.ReadOnly {
    override val action
        : Optional[zio.aws.securityhub.model.WafAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.securityhub.model.WafAction.wrap(value))
    override val excludedRules
        : Optional[List[zio.aws.securityhub.model.WafExcludedRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludedRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.WafExcludedRule.wrap(item)
          }.toList
        )
    override val overrideAction
        : Optional[zio.aws.securityhub.model.WafOverrideAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrideAction())
        .map(value => zio.aws.securityhub.model.WafOverrideAction.wrap(value))
    override val priority: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.priority())
      .map(value => value: Integer)
    override val ruleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val `type`: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafWebAclRule
  ): zio.aws.securityhub.model.AwsWafWebAclRule.ReadOnly = new Wrapper(impl)
}
