package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsWafRegionalWebAclDetails(
    defaultAction: Optional[NonEmptyString] = Optional.Absent,
    metricName: Optional[NonEmptyString] = Optional.Absent,
    name: Optional[NonEmptyString] = Optional.Absent,
    rulesList: Optional[
      Iterable[zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListDetails]
    ] = Optional.Absent,
    webAclId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclDetails = {
    import AwsWafRegionalWebAclDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclDetails
      .builder()
      .optionallyWith(
        defaultAction.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.defaultAction)
      .optionallyWith(
        metricName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.metricName)
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        rulesList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rulesList)
      .optionallyWith(
        webAclId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.webAclId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsWafRegionalWebAclDetails.ReadOnly =
    zio.aws.securityhub.model.AwsWafRegionalWebAclDetails.wrap(buildAwsValue())
}
object AwsWafRegionalWebAclDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsWafRegionalWebAclDetails =
      zio.aws.securityhub.model.AwsWafRegionalWebAclDetails(
        defaultAction.map(value => value),
        metricName.map(value => value),
        name.map(value => value),
        rulesList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        webAclId.map(value => value)
      )
    def defaultAction: Optional[NonEmptyString]
    def metricName: Optional[NonEmptyString]
    def name: Optional[NonEmptyString]
    def rulesList: Optional[List[
      zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListDetails.ReadOnly
    ]]
    def webAclId: Optional[NonEmptyString]
    def getDefaultAction: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("defaultAction", defaultAction)
    def getMetricName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getRulesList: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("rulesList", rulesList)
    def getWebAclId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("webAclId", webAclId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclDetails
  ) extends zio.aws.securityhub.model.AwsWafRegionalWebAclDetails.ReadOnly {
    override val defaultAction: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultAction())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val metricName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val rulesList: Optional[List[
      zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.rulesList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsWafRegionalWebAclRulesListDetails
            .wrap(item)
        }.toList
      )
    override val webAclId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.webAclId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsWafRegionalWebAclDetails
  ): zio.aws.securityhub.model.AwsWafRegionalWebAclDetails.ReadOnly =
    new Wrapper(impl)
}
