package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsSnsTopicDetails(
    kmsMasterKeyId: Optional[NonEmptyString] = Optional.Absent,
    subscription: Optional[
      Iterable[zio.aws.securityhub.model.AwsSnsTopicSubscription]
    ] = Optional.Absent,
    topicName: Optional[NonEmptyString] = Optional.Absent,
    owner: Optional[NonEmptyString] = Optional.Absent,
    sqsSuccessFeedbackRoleArn: Optional[NonEmptyString] = Optional.Absent,
    sqsFailureFeedbackRoleArn: Optional[NonEmptyString] = Optional.Absent,
    applicationSuccessFeedbackRoleArn: Optional[NonEmptyString] =
      Optional.Absent,
    firehoseSuccessFeedbackRoleArn: Optional[NonEmptyString] = Optional.Absent,
    firehoseFailureFeedbackRoleArn: Optional[NonEmptyString] = Optional.Absent,
    httpSuccessFeedbackRoleArn: Optional[NonEmptyString] = Optional.Absent,
    httpFailureFeedbackRoleArn: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsSnsTopicDetails = {
    import AwsSnsTopicDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsSnsTopicDetails
      .builder()
      .optionallyWith(
        kmsMasterKeyId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.kmsMasterKeyId)
      .optionallyWith(
        subscription.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscription)
      .optionallyWith(
        topicName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.topicName)
      .optionallyWith(
        owner.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        sqsSuccessFeedbackRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sqsSuccessFeedbackRoleArn)
      .optionallyWith(
        sqsFailureFeedbackRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.sqsFailureFeedbackRoleArn)
      .optionallyWith(
        applicationSuccessFeedbackRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.applicationSuccessFeedbackRoleArn)
      .optionallyWith(
        firehoseSuccessFeedbackRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.firehoseSuccessFeedbackRoleArn)
      .optionallyWith(
        firehoseFailureFeedbackRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.firehoseFailureFeedbackRoleArn)
      .optionallyWith(
        httpSuccessFeedbackRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.httpSuccessFeedbackRoleArn)
      .optionallyWith(
        httpFailureFeedbackRoleArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.httpFailureFeedbackRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsSnsTopicDetails.ReadOnly =
    zio.aws.securityhub.model.AwsSnsTopicDetails.wrap(buildAwsValue())
}
object AwsSnsTopicDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsSnsTopicDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsSnsTopicDetails =
      zio.aws.securityhub.model.AwsSnsTopicDetails(
        kmsMasterKeyId.map(value => value),
        subscription.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        topicName.map(value => value),
        owner.map(value => value),
        sqsSuccessFeedbackRoleArn.map(value => value),
        sqsFailureFeedbackRoleArn.map(value => value),
        applicationSuccessFeedbackRoleArn.map(value => value),
        firehoseSuccessFeedbackRoleArn.map(value => value),
        firehoseFailureFeedbackRoleArn.map(value => value),
        httpSuccessFeedbackRoleArn.map(value => value),
        httpFailureFeedbackRoleArn.map(value => value)
      )
    def kmsMasterKeyId: Optional[NonEmptyString]
    def subscription: Optional[
      List[zio.aws.securityhub.model.AwsSnsTopicSubscription.ReadOnly]
    ]
    def topicName: Optional[NonEmptyString]
    def owner: Optional[NonEmptyString]
    def sqsSuccessFeedbackRoleArn: Optional[NonEmptyString]
    def sqsFailureFeedbackRoleArn: Optional[NonEmptyString]
    def applicationSuccessFeedbackRoleArn: Optional[NonEmptyString]
    def firehoseSuccessFeedbackRoleArn: Optional[NonEmptyString]
    def firehoseFailureFeedbackRoleArn: Optional[NonEmptyString]
    def httpSuccessFeedbackRoleArn: Optional[NonEmptyString]
    def httpFailureFeedbackRoleArn: Optional[NonEmptyString]
    def getKmsMasterKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsMasterKeyId", kmsMasterKeyId)
    def getSubscription: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsSnsTopicSubscription.ReadOnly
    ]] = AwsError.unwrapOptionField("subscription", subscription)
    def getTopicName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("topicName", topicName)
    def getOwner: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("owner", owner)
    def getSqsSuccessFeedbackRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "sqsSuccessFeedbackRoleArn",
        sqsSuccessFeedbackRoleArn
      )
    def getSqsFailureFeedbackRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "sqsFailureFeedbackRoleArn",
        sqsFailureFeedbackRoleArn
      )
    def getApplicationSuccessFeedbackRoleArn
        : ZIO[Any, AwsError, NonEmptyString] = AwsError.unwrapOptionField(
      "applicationSuccessFeedbackRoleArn",
      applicationSuccessFeedbackRoleArn
    )
    def getFirehoseSuccessFeedbackRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "firehoseSuccessFeedbackRoleArn",
        firehoseSuccessFeedbackRoleArn
      )
    def getFirehoseFailureFeedbackRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "firehoseFailureFeedbackRoleArn",
        firehoseFailureFeedbackRoleArn
      )
    def getHttpSuccessFeedbackRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "httpSuccessFeedbackRoleArn",
        httpSuccessFeedbackRoleArn
      )
    def getHttpFailureFeedbackRoleArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "httpFailureFeedbackRoleArn",
        httpFailureFeedbackRoleArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSnsTopicDetails
  ) extends zio.aws.securityhub.model.AwsSnsTopicDetails.ReadOnly {
    override val kmsMasterKeyId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kmsMasterKeyId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val subscription: Optional[
      List[zio.aws.securityhub.model.AwsSnsTopicSubscription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.subscription())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsSnsTopicSubscription.wrap(item)
        }.toList
      )
    override val topicName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.topicName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val owner: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val sqsSuccessFeedbackRoleArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sqsSuccessFeedbackRoleArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val sqsFailureFeedbackRoleArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sqsFailureFeedbackRoleArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val applicationSuccessFeedbackRoleArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationSuccessFeedbackRoleArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val firehoseSuccessFeedbackRoleArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firehoseSuccessFeedbackRoleArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val firehoseFailureFeedbackRoleArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firehoseFailureFeedbackRoleArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val httpSuccessFeedbackRoleArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpSuccessFeedbackRoleArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val httpFailureFeedbackRoleArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpFailureFeedbackRoleArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsSnsTopicDetails
  ): zio.aws.securityhub.model.AwsSnsTopicDetails.ReadOnly = new Wrapper(impl)
}
