package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketWebsiteConfigurationRoutingRuleCondition(
    httpErrorCodeReturnedEquals: Optional[NonEmptyString] = Optional.Absent,
    keyPrefixEquals: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition = {
    import AwsS3BucketWebsiteConfigurationRoutingRuleCondition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition
      .builder()
      .optionallyWith(
        httpErrorCodeReturnedEquals.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.httpErrorCodeReturnedEquals)
      .optionallyWith(
        keyPrefixEquals.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.keyPrefixEquals)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition
      .wrap(buildAwsValue())
}
object AwsS3BucketWebsiteConfigurationRoutingRuleCondition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition =
      zio.aws.securityhub.model
        .AwsS3BucketWebsiteConfigurationRoutingRuleCondition(
          httpErrorCodeReturnedEquals.map(value => value),
          keyPrefixEquals.map(value => value)
        )
    def httpErrorCodeReturnedEquals: Optional[NonEmptyString]
    def keyPrefixEquals: Optional[NonEmptyString]
    def getHttpErrorCodeReturnedEquals: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "httpErrorCodeReturnedEquals",
        httpErrorCodeReturnedEquals
      )
    def getKeyPrefixEquals: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("keyPrefixEquals", keyPrefixEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition
  ) extends zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition.ReadOnly {
    override val httpErrorCodeReturnedEquals: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpErrorCodeReturnedEquals())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val keyPrefixEquals: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keyPrefixEquals())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition
  ): zio.aws.securityhub.model.AwsS3BucketWebsiteConfigurationRoutingRuleCondition.ReadOnly =
    new Wrapper(impl)
}
