package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketNotificationConfigurationS3KeyFilterRule(
    name: Optional[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRuleName
    ] = Optional.Absent,
    value: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule = {
    import AwsS3BucketNotificationConfigurationS3KeyFilterRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule
      .wrap(buildAwsValue())
}
object AwsS3BucketNotificationConfigurationS3KeyFilterRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule =
      zio.aws.securityhub.model
        .AwsS3BucketNotificationConfigurationS3KeyFilterRule(
          name.map(value => value),
          value.map(value => value)
        )
    def name: Optional[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRuleName
    ]
    def value: Optional[NonEmptyString]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRuleName
    ] = AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule
  ) extends zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule.ReadOnly {
    override val name: Optional[
      zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRuleName
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRuleName
          .wrap(value)
      )
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule
  ): zio.aws.securityhub.model.AwsS3BucketNotificationConfigurationS3KeyFilterRule.ReadOnly =
    new Wrapper(impl)
}
