package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsS3BucketBucketLifecycleConfigurationDetails(
    rules: Optional[Iterable[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails = {
    import AwsS3BucketBucketLifecycleConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails
      .builder()
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsS3BucketBucketLifecycleConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails =
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails(
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def rules: Optional[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails.ReadOnly
    ]]
    def getRules: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("rules", rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails.ReadOnly {
    override val rules: Optional[List[
      zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.rules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationRulesDetails
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails
  ): zio.aws.securityhub.model.AwsS3BucketBucketLifecycleConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
