package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsRedshiftClusterDeferredMaintenanceWindow(
    deferMaintenanceEndTime: Optional[NonEmptyString] = Optional.Absent,
    deferMaintenanceIdentifier: Optional[NonEmptyString] = Optional.Absent,
    deferMaintenanceStartTime: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow = {
    import AwsRedshiftClusterDeferredMaintenanceWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow
      .builder()
      .optionallyWith(
        deferMaintenanceEndTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.deferMaintenanceEndTime)
      .optionallyWith(
        deferMaintenanceIdentifier.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.deferMaintenanceIdentifier)
      .optionallyWith(
        deferMaintenanceStartTime.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.deferMaintenanceStartTime)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow.ReadOnly =
    zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow
      .wrap(buildAwsValue())
}
object AwsRedshiftClusterDeferredMaintenanceWindow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow =
      zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow(
        deferMaintenanceEndTime.map(value => value),
        deferMaintenanceIdentifier.map(value => value),
        deferMaintenanceStartTime.map(value => value)
      )
    def deferMaintenanceEndTime: Optional[NonEmptyString]
    def deferMaintenanceIdentifier: Optional[NonEmptyString]
    def deferMaintenanceStartTime: Optional[NonEmptyString]
    def getDeferMaintenanceEndTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "deferMaintenanceEndTime",
        deferMaintenanceEndTime
      )
    def getDeferMaintenanceIdentifier: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "deferMaintenanceIdentifier",
        deferMaintenanceIdentifier
      )
    def getDeferMaintenanceStartTime: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField(
        "deferMaintenanceStartTime",
        deferMaintenanceStartTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow
  ) extends zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow.ReadOnly {
    override val deferMaintenanceEndTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deferMaintenanceEndTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val deferMaintenanceIdentifier: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deferMaintenanceIdentifier())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val deferMaintenanceStartTime: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deferMaintenanceStartTime())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow
  ): zio.aws.securityhub.model.AwsRedshiftClusterDeferredMaintenanceWindow.ReadOnly =
    new Wrapper(impl)
}
