package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsNetworkFirewallFirewallDetails(
    deleteProtection: Optional[Boolean] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    firewallArn: Optional[NonEmptyString] = Optional.Absent,
    firewallId: Optional[NonEmptyString] = Optional.Absent,
    firewallName: Optional[NonEmptyString] = Optional.Absent,
    firewallPolicyArn: Optional[NonEmptyString] = Optional.Absent,
    firewallPolicyChangeProtection: Optional[Boolean] = Optional.Absent,
    subnetChangeProtection: Optional[Boolean] = Optional.Absent,
    subnetMappings: Optional[Iterable[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails
    ]] = Optional.Absent,
    vpcId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallDetails = {
    import AwsNetworkFirewallFirewallDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallDetails
      .builder()
      .optionallyWith(deleteProtection.map(value => value: java.lang.Boolean))(
        _.deleteProtection
      )
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        firewallArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.firewallArn)
      .optionallyWith(
        firewallId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.firewallId)
      .optionallyWith(
        firewallName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.firewallName)
      .optionallyWith(
        firewallPolicyArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.firewallPolicyArn)
      .optionallyWith(
        firewallPolicyChangeProtection.map(value => value: java.lang.Boolean)
      )(_.firewallPolicyChangeProtection)
      .optionallyWith(
        subnetChangeProtection.map(value => value: java.lang.Boolean)
      )(_.subnetChangeProtection)
      .optionallyWith(
        subnetMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subnetMappings)
      .optionallyWith(
        vpcId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails.ReadOnly =
    zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails
      .wrap(buildAwsValue())
}
object AwsNetworkFirewallFirewallDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails =
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails(
        deleteProtection.map(value => value),
        description.map(value => value),
        firewallArn.map(value => value),
        firewallId.map(value => value),
        firewallName.map(value => value),
        firewallPolicyArn.map(value => value),
        firewallPolicyChangeProtection.map(value => value),
        subnetChangeProtection.map(value => value),
        subnetMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        vpcId.map(value => value)
      )
    def deleteProtection: Optional[Boolean]
    def description: Optional[NonEmptyString]
    def firewallArn: Optional[NonEmptyString]
    def firewallId: Optional[NonEmptyString]
    def firewallName: Optional[NonEmptyString]
    def firewallPolicyArn: Optional[NonEmptyString]
    def firewallPolicyChangeProtection: Optional[Boolean]
    def subnetChangeProtection: Optional[Boolean]
    def subnetMappings: Optional[List[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails.ReadOnly
    ]]
    def vpcId: Optional[NonEmptyString]
    def getDeleteProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteProtection", deleteProtection)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getFirewallArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallArn", firewallArn)
    def getFirewallId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallId", firewallId)
    def getFirewallName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallName", firewallName)
    def getFirewallPolicyArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("firewallPolicyArn", firewallPolicyArn)
    def getFirewallPolicyChangeProtection: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "firewallPolicyChangeProtection",
        firewallPolicyChangeProtection
      )
    def getSubnetChangeProtection: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("subnetChangeProtection", subnetChangeProtection)
    def getSubnetMappings: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("subnetMappings", subnetMappings)
    def getVpcId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallDetails
  ) extends zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails.ReadOnly {
    override val deleteProtection: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteProtection())
      .map(value => value: Boolean)
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val firewallArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val firewallId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val firewallName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.firewallName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val firewallPolicyArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallPolicyArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val firewallPolicyChangeProtection: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firewallPolicyChangeProtection())
        .map(value => value: Boolean)
    override val subnetChangeProtection: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subnetChangeProtection())
        .map(value => value: Boolean)
    override val subnetMappings: Optional[List[
      zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsNetworkFirewallFirewallSubnetMappingsDetails
            .wrap(item)
        }.toList
      )
    override val vpcId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsNetworkFirewallFirewallDetails
  ): zio.aws.securityhub.model.AwsNetworkFirewallFirewallDetails.ReadOnly =
    new Wrapper(impl)
}
