package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{
  AwsIamRoleAssumeRolePolicyDocument,
  NonEmptyString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsIamInstanceProfileRole(
    arn: Optional[NonEmptyString] = Optional.Absent,
    assumeRolePolicyDocument: Optional[AwsIamRoleAssumeRolePolicyDocument] =
      Optional.Absent,
    createDate: Optional[NonEmptyString] = Optional.Absent,
    path: Optional[NonEmptyString] = Optional.Absent,
    roleId: Optional[NonEmptyString] = Optional.Absent,
    roleName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfileRole = {
    import AwsIamInstanceProfileRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfileRole
      .builder()
      .optionallyWith(
        arn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        assumeRolePolicyDocument.map(value =>
          AwsIamRoleAssumeRolePolicyDocument.unwrap(value): java.lang.String
        )
      )(_.assumeRolePolicyDocument)
      .optionallyWith(
        createDate.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createDate)
      .optionallyWith(
        path.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.path)
      .optionallyWith(
        roleId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleId)
      .optionallyWith(
        roleName.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.roleName)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsIamInstanceProfileRole.ReadOnly =
    zio.aws.securityhub.model.AwsIamInstanceProfileRole.wrap(buildAwsValue())
}
object AwsIamInstanceProfileRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfileRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsIamInstanceProfileRole =
      zio.aws.securityhub.model.AwsIamInstanceProfileRole(
        arn.map(value => value),
        assumeRolePolicyDocument.map(value => value),
        createDate.map(value => value),
        path.map(value => value),
        roleId.map(value => value),
        roleName.map(value => value)
      )
    def arn: Optional[NonEmptyString]
    def assumeRolePolicyDocument: Optional[AwsIamRoleAssumeRolePolicyDocument]
    def createDate: Optional[NonEmptyString]
    def path: Optional[NonEmptyString]
    def roleId: Optional[NonEmptyString]
    def roleName: Optional[NonEmptyString]
    def getArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arn)
    def getAssumeRolePolicyDocument
        : ZIO[Any, AwsError, AwsIamRoleAssumeRolePolicyDocument] = AwsError
      .unwrapOptionField("assumeRolePolicyDocument", assumeRolePolicyDocument)
    def getCreateDate: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("path", path)
    def getRoleId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleId", roleId)
    def getRoleName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("roleName", roleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfileRole
  ) extends zio.aws.securityhub.model.AwsIamInstanceProfileRole.ReadOnly {
    override val arn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val assumeRolePolicyDocument
        : Optional[AwsIamRoleAssumeRolePolicyDocument] = zio.aws.core.internal
      .optionalFromNullable(impl.assumeRolePolicyDocument())
      .map(value =>
        zio.aws.securityhub.model.primitives
          .AwsIamRoleAssumeRolePolicyDocument(value)
      )
    override val createDate: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val path: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val roleId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roleId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val roleName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.roleName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfileRole
  ): zio.aws.securityhub.model.AwsIamInstanceProfileRole.ReadOnly = new Wrapper(
    impl
  )
}
