package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsElasticsearchDomainEncryptionAtRestOptions(
    enabled: Optional[Boolean] = Optional.Absent,
    kmsKeyId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions = {
    import AwsElasticsearchDomainEncryptionAtRestOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .optionallyWith(
        kmsKeyId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions.ReadOnly =
    zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions
      .wrap(buildAwsValue())
}
object AwsElasticsearchDomainEncryptionAtRestOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions =
      zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions(
        enabled.map(value => value),
        kmsKeyId.map(value => value)
      )
    def enabled: Optional[Boolean]
    def kmsKeyId: Optional[NonEmptyString]
    def getEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
    def getKmsKeyId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions
  ) extends zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions.ReadOnly {
    override val enabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: Boolean)
    override val kmsKeyId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions
  ): zio.aws.securityhub.model.AwsElasticsearchDomainEncryptionAtRestOptions.ReadOnly =
    new Wrapper(impl)
}
