package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDetails(
    clusterArn: Optional[NonEmptyString] = Optional.Absent,
    taskDefinitionArn: Optional[NonEmptyString] = Optional.Absent,
    version: Optional[NonEmptyString] = Optional.Absent,
    createdAt: Optional[NonEmptyString] = Optional.Absent,
    startedAt: Optional[NonEmptyString] = Optional.Absent,
    startedBy: Optional[NonEmptyString] = Optional.Absent,
    group: Optional[NonEmptyString] = Optional.Absent,
    volumes: Optional[
      Iterable[zio.aws.securityhub.model.AwsEcsTaskVolumeDetails]
    ] = Optional.Absent,
    containers: Optional[
      Iterable[zio.aws.securityhub.model.AwsEcsContainerDetails]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDetails = {
    import AwsEcsTaskDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDetails
      .builder()
      .optionallyWith(
        clusterArn.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.clusterArn)
      .optionallyWith(
        taskDefinitionArn.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.taskDefinitionArn)
      .optionallyWith(
        version.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.version)
      .optionallyWith(
        createdAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.createdAt)
      .optionallyWith(
        startedAt.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.startedAt)
      .optionallyWith(
        startedBy.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.startedBy)
      .optionallyWith(
        group.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.group)
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .optionallyWith(
        containers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.containers)
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEcsTaskDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDetails.wrap(buildAwsValue())
}
object AwsEcsTaskDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEcsTaskDetails =
      zio.aws.securityhub.model.AwsEcsTaskDetails(
        clusterArn.map(value => value),
        taskDefinitionArn.map(value => value),
        version.map(value => value),
        createdAt.map(value => value),
        startedAt.map(value => value),
        startedBy.map(value => value),
        group.map(value => value),
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        containers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterArn: Optional[NonEmptyString]
    def taskDefinitionArn: Optional[NonEmptyString]
    def version: Optional[NonEmptyString]
    def createdAt: Optional[NonEmptyString]
    def startedAt: Optional[NonEmptyString]
    def startedBy: Optional[NonEmptyString]
    def group: Optional[NonEmptyString]
    def volumes: Optional[
      List[zio.aws.securityhub.model.AwsEcsTaskVolumeDetails.ReadOnly]
    ]
    def containers: Optional[
      List[zio.aws.securityhub.model.AwsEcsContainerDetails.ReadOnly]
    ]
    def getClusterArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getTaskDefinitionArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("taskDefinitionArn", taskDefinitionArn)
    def getVersion: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("version", version)
    def getCreatedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStartedAt: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("startedAt", startedAt)
    def getStartedBy: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("startedBy", startedBy)
    def getGroup: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("group", group)
    def getVolumes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsTaskVolumeDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("volumes", volumes)
    def getContainers: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEcsContainerDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("containers", containers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDetails.ReadOnly {
    override val clusterArn: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val taskDefinitionArn: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskDefinitionArn())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val version: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val createdAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val startedAt: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.startedAt())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val startedBy: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.startedBy())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val group: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.group())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val volumes: Optional[
      List[zio.aws.securityhub.model.AwsEcsTaskVolumeDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.volumes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsTaskVolumeDetails.wrap(item)
        }.toList
      )
    override val containers: Optional[
      List[zio.aws.securityhub.model.AwsEcsContainerDetails.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.containers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEcsContainerDetails.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDetails.ReadOnly = new Wrapper(impl)
}
