package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails(
    accessPointId: Optional[NonEmptyString] = Optional.Absent,
    iam: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails = {
    import AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
      .builder()
      .optionallyWith(
        accessPointId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.accessPointId)
      .optionallyWith(
        iam.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.iam)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails(
          accessPointId.map(value => value),
          iam.map(value => value)
        )
    def accessPointId: Optional[NonEmptyString]
    def iam: Optional[NonEmptyString]
    def getAccessPointId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("accessPointId", accessPointId)
    def getIam: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("iam", iam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.ReadOnly {
    override val accessPointId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.accessPointId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val iam: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.iam())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails.ReadOnly =
    new Wrapper(impl)
}
