package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(
    autoprovision: Optional[Boolean] = Optional.Absent,
    driver: Optional[NonEmptyString] = Optional.Absent,
    driverOpts: Optional[Map[NonEmptyString, NonEmptyString]] = Optional.Absent,
    labels: Optional[Map[NonEmptyString, NonEmptyString]] = Optional.Absent,
    scope: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails = {
    import AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
      .builder()
      .optionallyWith(autoprovision.map(value => value: java.lang.Boolean))(
        _.autoprovision
      )
      .optionallyWith(
        driver.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.driver)
      .optionallyWith(
        driverOpts.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.driverOpts)
      .optionallyWith(
        labels.map(value =>
          value
            .map({ case (key, value) =>
              (NonEmptyString.unwrap(key): java.lang.String) -> (NonEmptyString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.labels)
      .optionallyWith(
        scope.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.scope)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails(
          autoprovision.map(value => value),
          driver.map(value => value),
          driverOpts.map(value => value),
          labels.map(value => value),
          scope.map(value => value)
        )
    def autoprovision: Optional[Boolean]
    def driver: Optional[NonEmptyString]
    def driverOpts: Optional[Map[NonEmptyString, NonEmptyString]]
    def labels: Optional[Map[NonEmptyString, NonEmptyString]]
    def scope: Optional[NonEmptyString]
    def getAutoprovision: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("autoprovision", autoprovision)
    def getDriver: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("driver", driver)
    def getDriverOpts: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("driverOpts", driverOpts)
    def getLabels: ZIO[Any, AwsError, Map[NonEmptyString, NonEmptyString]] =
      AwsError.unwrapOptionField("labels", labels)
    def getScope: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("scope", scope)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.ReadOnly {
    override val autoprovision: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.autoprovision())
      .map(value => value: Boolean)
    override val driver: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.driver())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val driverOpts: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.driverOpts())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val labels: Optional[Map[NonEmptyString, NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labels())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.securityhub.model.primitives.NonEmptyString(
                key
              ) -> zio.aws.securityhub.model.primitives.NonEmptyString(value)
            })
            .toMap
        )
    override val scope: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.scope())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionVolumesDockerVolumeConfigurationDetails.ReadOnly =
    new Wrapper(impl)
}
