package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails(
    condition: Optional[NonEmptyString] = Optional.Absent,
    containerName: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails = {
    import AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
      .builder()
      .optionallyWith(
        condition.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.condition)
      .optionallyWith(
        containerName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.containerName)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
      .wrap(buildAwsValue())
}
object AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails =
      zio.aws.securityhub.model
        .AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails(
          condition.map(value => value),
          containerName.map(value => value)
        )
    def condition: Optional[NonEmptyString]
    def containerName: Optional[NonEmptyString]
    def getCondition: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("condition", condition)
    def getContainerName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("containerName", containerName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
  ) extends zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.ReadOnly {
    override val condition: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.condition())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val containerName: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.containerName())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
  ): zio.aws.securityhub.model.AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.ReadOnly =
    new Wrapper(impl)
}
