package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEcsContainerDetails(
    name: Optional[NonEmptyString] = Optional.Absent,
    image: Optional[NonEmptyString] = Optional.Absent,
    mountPoints: Optional[Iterable[zio.aws.securityhub.model.AwsMountPoint]] =
      Optional.Absent,
    privileged: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEcsContainerDetails = {
    import AwsEcsContainerDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEcsContainerDetails
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        image.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.image)
      .optionallyWith(
        mountPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.mountPoints)
      .optionallyWith(privileged.map(value => value: java.lang.Boolean))(
        _.privileged
      )
      .build()
  }
  def asReadOnly: zio.aws.securityhub.model.AwsEcsContainerDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEcsContainerDetails.wrap(buildAwsValue())
}
object AwsEcsContainerDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEcsContainerDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEcsContainerDetails =
      zio.aws.securityhub.model.AwsEcsContainerDetails(
        name.map(value => value),
        image.map(value => value),
        mountPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        privileged.map(value => value)
      )
    def name: Optional[NonEmptyString]
    def image: Optional[NonEmptyString]
    def mountPoints
        : Optional[List[zio.aws.securityhub.model.AwsMountPoint.ReadOnly]]
    def privileged: Optional[Boolean]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getImage: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("image", image)
    def getMountPoints: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsMountPoint.ReadOnly
    ]] = AwsError.unwrapOptionField("mountPoints", mountPoints)
    def getPrivileged: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("privileged", privileged)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsContainerDetails
  ) extends zio.aws.securityhub.model.AwsEcsContainerDetails.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val image: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.image())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val mountPoints
        : Optional[List[zio.aws.securityhub.model.AwsMountPoint.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountPoints())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.securityhub.model.AwsMountPoint.wrap(item)
          }.toList
        )
    override val privileged: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.privileged())
      .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEcsContainerDetails
  ): zio.aws.securityhub.model.AwsEcsContainerDetails.ReadOnly = new Wrapper(
    impl
  )
}
