package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.NonEmptyString
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDetails(
    launchTemplateName: Optional[NonEmptyString] = Optional.Absent,
    id: Optional[NonEmptyString] = Optional.Absent,
    launchTemplateData: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataDetails
    ] = Optional.Absent,
    defaultVersionNumber: Optional[Long] = Optional.Absent,
    latestVersionNumber: Optional[Long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDetails = {
    import AwsEc2LaunchTemplateDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDetails
      .builder()
      .optionallyWith(
        launchTemplateName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(launchTemplateData.map(value => value.buildAwsValue()))(
        _.launchTemplateData
      )
      .optionallyWith(defaultVersionNumber.map(value => value: java.lang.Long))(
        _.defaultVersionNumber
      )
      .optionallyWith(latestVersionNumber.map(value => value: java.lang.Long))(
        _.latestVersionNumber
      )
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDetails.wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.securityhub.model.AwsEc2LaunchTemplateDetails =
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDetails(
        launchTemplateName.map(value => value),
        id.map(value => value),
        launchTemplateData.map(value => value.asEditable),
        defaultVersionNumber.map(value => value),
        latestVersionNumber.map(value => value)
      )
    def launchTemplateName: Optional[NonEmptyString]
    def id: Optional[NonEmptyString]
    def launchTemplateData: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataDetails.ReadOnly
    ]
    def defaultVersionNumber: Optional[Long]
    def latestVersionNumber: Optional[Long]
    def getLaunchTemplateName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getLaunchTemplateData: ZIO[
      Any,
      AwsError,
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("launchTemplateData", launchTemplateData)
    def getDefaultVersionNumber: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("defaultVersionNumber", defaultVersionNumber)
    def getLatestVersionNumber: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("latestVersionNumber", latestVersionNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDetails.ReadOnly {
    override val launchTemplateName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.launchTemplateName())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val id: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val launchTemplateData: Optional[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.launchTemplateData())
      .map(value =>
        zio.aws.securityhub.model.AwsEc2LaunchTemplateDataDetails.wrap(value)
      )
    override val defaultVersionNumber: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultVersionNumber())
      .map(value => value: Long)
    override val latestVersionNumber: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.latestVersionNumber())
      .map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDetails.ReadOnly =
    new Wrapper(impl)
}
