package zio.aws.securityhub.model
import zio.ZIO
import zio.aws.securityhub.model.primitives.{Integer, NonEmptyString}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails(
    associateCarrierIpAddress: Optional[Boolean] = Optional.Absent,
    associatePublicIpAddress: Optional[Boolean] = Optional.Absent,
    deleteOnTermination: Optional[Boolean] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    deviceIndex: Optional[Integer] = Optional.Absent,
    groups: Optional[Iterable[NonEmptyString]] = Optional.Absent,
    interfaceType: Optional[NonEmptyString] = Optional.Absent,
    ipv4PrefixCount: Optional[Integer] = Optional.Absent,
    ipv4Prefixes: Optional[Iterable[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails
    ]] = Optional.Absent,
    ipv6AddressCount: Optional[Integer] = Optional.Absent,
    ipv6Addresses: Optional[Iterable[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails
    ]] = Optional.Absent,
    ipv6PrefixCount: Optional[Integer] = Optional.Absent,
    ipv6Prefixes: Optional[Iterable[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails
    ]] = Optional.Absent,
    networkCardIndex: Optional[Integer] = Optional.Absent,
    networkInterfaceId: Optional[NonEmptyString] = Optional.Absent,
    privateIpAddress: Optional[NonEmptyString] = Optional.Absent,
    privateIpAddresses: Optional[Iterable[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails
    ]] = Optional.Absent,
    secondaryPrivateIpAddressCount: Optional[Integer] = Optional.Absent,
    subnetId: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails = {
    import AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails
      .builder()
      .optionallyWith(
        associateCarrierIpAddress.map(value => value: java.lang.Boolean)
      )(_.associateCarrierIpAddress)
      .optionallyWith(
        associatePublicIpAddress.map(value => value: java.lang.Boolean)
      )(_.associatePublicIpAddress)
      .optionallyWith(
        deleteOnTermination.map(value => value: java.lang.Boolean)
      )(_.deleteOnTermination)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(deviceIndex.map(value => value: java.lang.Integer))(
        _.deviceIndex
      )
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        interfaceType.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.interfaceType)
      .optionallyWith(ipv4PrefixCount.map(value => value: java.lang.Integer))(
        _.ipv4PrefixCount
      )
      .optionallyWith(
        ipv4Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv4Prefixes)
      .optionallyWith(ipv6AddressCount.map(value => value: java.lang.Integer))(
        _.ipv6AddressCount
      )
      .optionallyWith(
        ipv6Addresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Addresses)
      .optionallyWith(ipv6PrefixCount.map(value => value: java.lang.Integer))(
        _.ipv6PrefixCount
      )
      .optionallyWith(
        ipv6Prefixes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ipv6Prefixes)
      .optionallyWith(networkCardIndex.map(value => value: java.lang.Integer))(
        _.networkCardIndex
      )
      .optionallyWith(
        networkInterfaceId.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.networkInterfaceId)
      .optionallyWith(
        privateIpAddress.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.privateIpAddress)
      .optionallyWith(
        privateIpAddresses.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.privateIpAddresses)
      .optionallyWith(
        secondaryPrivateIpAddressCount.map(value => value: java.lang.Integer)
      )(_.secondaryPrivateIpAddressCount)
      .optionallyWith(
        subnetId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.subnetId)
      .build()
  }
  def asReadOnly
      : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.ReadOnly =
    zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails
      .wrap(buildAwsValue())
}
object AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails =
      zio.aws.securityhub.model
        .AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails(
          associateCarrierIpAddress.map(value => value),
          associatePublicIpAddress.map(value => value),
          deleteOnTermination.map(value => value),
          description.map(value => value),
          deviceIndex.map(value => value),
          groups.map(value => value),
          interfaceType.map(value => value),
          ipv4PrefixCount.map(value => value),
          ipv4Prefixes.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          ipv6AddressCount.map(value => value),
          ipv6Addresses.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          ipv6PrefixCount.map(value => value),
          ipv6Prefixes.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          networkCardIndex.map(value => value),
          networkInterfaceId.map(value => value),
          privateIpAddress.map(value => value),
          privateIpAddresses.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          secondaryPrivateIpAddressCount.map(value => value),
          subnetId.map(value => value)
        )
    def associateCarrierIpAddress: Optional[Boolean]
    def associatePublicIpAddress: Optional[Boolean]
    def deleteOnTermination: Optional[Boolean]
    def description: Optional[NonEmptyString]
    def deviceIndex: Optional[Integer]
    def groups: Optional[List[NonEmptyString]]
    def interfaceType: Optional[NonEmptyString]
    def ipv4PrefixCount: Optional[Integer]
    def ipv4Prefixes: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.ReadOnly
    ]]
    def ipv6AddressCount: Optional[Integer]
    def ipv6Addresses: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.ReadOnly
    ]]
    def ipv6PrefixCount: Optional[Integer]
    def ipv6Prefixes: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.ReadOnly
    ]]
    def networkCardIndex: Optional[Integer]
    def networkInterfaceId: Optional[NonEmptyString]
    def privateIpAddress: Optional[NonEmptyString]
    def privateIpAddresses: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.ReadOnly
    ]]
    def secondaryPrivateIpAddressCount: Optional[Integer]
    def subnetId: Optional[NonEmptyString]
    def getAssociateCarrierIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associateCarrierIpAddress", associateCarrierIpAddress)
    def getAssociatePublicIpAddress: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("associatePublicIpAddress", associatePublicIpAddress)
    def getDeleteOnTermination: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("deleteOnTermination", deleteOnTermination)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("deviceIndex", deviceIndex)
    def getGroups: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("groups", groups)
    def getInterfaceType: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("interfaceType", interfaceType)
    def getIpv4PrefixCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv4PrefixCount", ipv4PrefixCount)
    def getIpv4Prefixes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv4Prefixes", ipv4Prefixes)
    def getIpv6AddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6AddressCount", ipv6AddressCount)
    def getIpv6Addresses: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Addresses", ipv6Addresses)
    def getIpv6PrefixCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("ipv6PrefixCount", ipv6PrefixCount)
    def getIpv6Prefixes: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("ipv6Prefixes", ipv6Prefixes)
    def getNetworkCardIndex: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("networkCardIndex", networkCardIndex)
    def getNetworkInterfaceId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("networkInterfaceId", networkInterfaceId)
    def getPrivateIpAddress: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("privateIpAddress", privateIpAddress)
    def getPrivateIpAddresses: ZIO[Any, AwsError, List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("privateIpAddresses", privateIpAddresses)
    def getSecondaryPrivateIpAddressCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "secondaryPrivateIpAddressCount",
        secondaryPrivateIpAddressCount
      )
    def getSubnetId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("subnetId", subnetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails
  ) extends zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.ReadOnly {
    override val associateCarrierIpAddress: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associateCarrierIpAddress())
        .map(value => value: Boolean)
    override val associatePublicIpAddress: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associatePublicIpAddress())
        .map(value => value: Boolean)
    override val deleteOnTermination: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.deleteOnTermination())
      .map(value => value: Boolean)
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val deviceIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceIndex())
      .map(value => value: Integer)
    override val groups: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.groups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.primitives.NonEmptyString(item)
        }.toList
      )
    override val interfaceType: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.interfaceType())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
    override val ipv4PrefixCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv4PrefixCount())
      .map(value => value: Integer)
    override val ipv4Prefixes: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv4Prefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails
            .wrap(item)
        }.toList
      )
    override val ipv6AddressCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6AddressCount())
      .map(value => value: Integer)
    override val ipv6Addresses: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Addresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails
            .wrap(item)
        }.toList
      )
    override val ipv6PrefixCount: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6PrefixCount())
      .map(value => value: Integer)
    override val ipv6Prefixes: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.ipv6Prefixes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails
            .wrap(item)
        }.toList
      )
    override val networkCardIndex: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.networkCardIndex())
      .map(value => value: Integer)
    override val networkInterfaceId: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceId())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val privateIpAddress: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.privateIpAddress())
        .map(value =>
          zio.aws.securityhub.model.primitives.NonEmptyString(value)
        )
    override val privateIpAddresses: Optional[List[
      zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.privateIpAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails
            .wrap(item)
        }.toList
      )
    override val secondaryPrivateIpAddressCount: Optional[Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.secondaryPrivateIpAddressCount())
        .map(value => value: Integer)
    override val subnetId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetId())
      .map(value => zio.aws.securityhub.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails
  ): zio.aws.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.ReadOnly =
    new Wrapper(impl)
}
